% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dodgr-package.R
\docType{package}
\name{dodgr}
\alias{dodgr-package}
\alias{dodgr}
\title{Distances On Directed GRaphs ("dodgr")}
\description{
Distances on dual-weighted directed graphs using priority-queue shortest
paths. Weighted directed graphs have weights from A to B which may differ
from those from B to A. Dual-weighted directed graphs have two sets of such
weights. A canonical example is a street network to be used for routing in
which routes are calculated by weighting distances according to the type of
way and mode of transport, yet lengths of routes must be calculated from
direct distances.
}
\section{The Main Function}{

\itemize{
\item \code{\link[=dodgr_dists]{dodgr_dists()}}: Calculate pair-wise distances between
specified pairs of points in a graph.
}
}

\section{Functions to Obtain Graphs}{

\itemize{
\item \code{\link[=dodgr_streetnet]{dodgr_streetnet()}}: Extract a street network in Simple
Features (\code{sf}) form.
\item \code{\link[=weight_streetnet]{weight_streetnet()}}: Convert an \code{sf}-formatted street
network to a \code{dodgr} graph through applying specified weights to all
edges.
}
}

\section{Functions to Modify Graphs}{

\itemize{
\item \code{\link[=dodgr_components]{dodgr_components()}}: Number all graph edges according to
their presence in distinct connected components.
\item \code{\link[=dodgr_contract_graph]{dodgr_contract_graph()}}: Contract a graph by removing
redundant edges.
}
}

\section{Miscellaneous Functions}{

\itemize{
\item \code{\link[=dodgr_sample]{dodgr_sample()}}: Randomly sample a graph, returning a single
connected component of a defined number of vertices.
\item \code{\link[=dodgr_vertices]{dodgr_vertices()}}: Extract all vertices of a graph.
\item \code{\link[=compare_heaps]{compare_heaps()}}: Compare the performance of different
priority queue heap structures for a given type of graph.
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://UrbanAnalyst.github.io/dodgr/}
  \item \url{https://github.com/UrbanAnalyst/dodgr}
  \item Report bugs at \url{https://github.com/UrbanAnalyst/dodgr/issues}
}

}
\author{
\strong{Maintainer}: Mark Padgham \email{mark.padgham@email.com}

Authors:
\itemize{
  \item Andreas Petutschnig
  \item David Cooley
}

Other contributors:
\itemize{
  \item Robin Lovelace [contributor]
  \item Andrew Smith [contributor]
  \item Malcolm Morgan [contributor]
  \item Andrea Gilardi (\href{https://orcid.org/0000-0002-9424-7439}{ORCID}) [contributor]
  \item Eduardo Leoni (\href{https://orcid.org/0000-0003-0955-5232}{ORCID}) [contributor]
  \item Shane Saunders (Original author of included code for priority heaps) [copyright holder]
  \item Stanislaw Adaszewski (author of include concaveman-cpp code) [copyright holder]
}

}
\concept{package}
