% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniquedouble.R
\name{uniquedouble}
\alias{uniquedouble}
\title{Turn a 64-bit integer into a unique double value}
\usage{
uniquedouble(int64)
}
\arguments{
\item{int64}{input value (normally used with 64-bit integers, but also works with other types)}
}
\value{
Returns a double floating point value.
}
\description{
Turns a 64-bit integers into unique doubles for faster comparison. The output double values are completely different from the input values.
}
\examples{

# The comparison of in-built types is very fast:
int32 = as.integer(0) # (same as int32 = 0)
system.time(for(i in seq(1e4)) comparison=int32==int32)

# The comparison of 64-bit integers is very slow:
int64 = bit64::as.integer64(0)
system.time(for(i in seq(1e4)) comparison=int64==int64)

# The comparison of converted 64-bit integers is again fast:
int64d = uniquedouble(int64)
system.time(for(i in seq(1e4)) comparison=int64d==int64d)

}
\author{
Danail Obreschkow
}
