#' @title
#' The Package Logo
#'
#' @description
#' The logo is generated by [parabar::make_logo()] and displayed on package
#' attach for interactive `R` sessions.
#'
#' @format
#' An object of class `character` containing the `ASCII` logo.
#'
#' @details
#' The logo is based on the `doParabar-logo.txt` template file located under the
#' `inst/assets` directory of the package.
#'
#' @seealso [parabar::make_logo()]
#'
#' @keywords internal
LOGO = ". . . . . . . . . . . . . . . . . . . . . . . . . . .\n.                              _             v1.x.x .\n.  do                         | |                   .\n.   _ __    __ _  _ __   __ _ | |__    __ _  _ __   .\n.  | '_ \\  / _` || '__| / _` || '_ \\  / _` || '__|  .\n.  | |_) || (_| || |   | (_| || |_) || (_| || |     .\n.  | .__/  \\____||_|    \\____||____/  \\____||_|     .\n.  | |                                              .\n.  |_|                                              .\n.                                                   .\n. . . . . . . . . . . . . . . . . . . . . . . . . . .\n.                         .                         .\n.        https://parabar.mihaiconstantin.com        .\n.                         .                         .\n. . . . . . . . . . . . . . . . . . . . . . . . . . ."

# Add package logo class.
class(LOGO) <- "doParabar"

# An `S3` method for properly printing the logo.
#' @export
print.doParabar <- function(x, ...) {
    # Print the logo.
    cat(LOGO, sep = "")
}
