% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnose.R
\name{diagnose_outlier}
\alias{diagnose_outlier}
\alias{diagnose_outlier.data.frame}
\alias{diagnose_outlier.grouped_df}
\title{Diagnose outlier of numerical variables}
\usage{
diagnose_outlier(.data, ...)

\method{diagnose_outlier}{data.frame}(.data, ...)

\method{diagnose_outlier}{grouped_df}(.data, ...)
}
\arguments{
\item{.data}{a data.frame or a \code{\link[tibble]{tbl_df}} or a \code{\link[dplyr]{grouped_df}}.}

\item{...}{one or more unquoted expressions separated by commas.
You can treat variable names like they are positions.
Positive values select variables; negative values to drop variables.
If the first expression is negative, diagnose_outlier() will automatically
start with all variables.
These arguments are automatically quoted and evaluated in a context
where column names represent column positions.
They support unquoting and splicing.}
}
\value{
an object of tbl_df.
}
\description{
The diagnose_outlier() produces outlier information
for diagnosing the quality of the numerical data.
}
\details{
The scope of the diagnosis is the provide a outlier information.
If the number of outliers is small and the difference between the averages
including outliers and the averages not including them is large,
it is necessary to eliminate or replace the outliers.
}
\section{Outlier Diagnostic information}{

The information derived from the numerical data diagnosis is as follows.

\itemize{
\item variables : variable names
\item outliers_cnt : number of outliers
\item outliers_ratio : percent of outliers
\item outliers_mean : arithmetic average of outliers
\item with_mean : arithmetic average of with outliers
\item without_mean : arithmetic average of without outliers
}

See vignette("diagonosis") for an introduction to these concepts.
}

\examples{
\donttest{
# Diagnosis of numerical variables
diagnose_outlier(heartfailure)

# Select the variable to diagnose
diagnose_outlier(heartfailure, cpk_enzyme, sodium)
diagnose_outlier(heartfailure, -cpk_enzyme, -sodium)
diagnose_outlier(heartfailure, "cpk_enzyme", "sodium")
diagnose_outlier(heartfailure, 5)

# Using pipes ---------------------------------
library(dplyr)

# Diagnosis of all numerical variables
heartfailure \%>\%
  diagnose_outlier()
# Positive values select variables
heartfailure \%>\%
  diagnose_outlier(cpk_enzyme, sodium)
# Negative values to drop variables
heartfailure \%>\%
  diagnose_outlier(-cpk_enzyme, -sodium)
# Positions values select variables
heartfailure \%>\%
  diagnose_outlier(5)
# Negative values to drop variables
heartfailure \%>\%
  diagnose_outlier(-1, -5)

# Using pipes & dplyr -------------------------
# outlier_ratio is more than 1\%
heartfailure \%>\%
  diagnose_outlier()  \%>\%
  filter(outliers_ratio > 1)
  
# Using group_by ------------------------------
# Calculate the diagnosis of all variables by 'death_event' using group_by()
heartfailure \%>\%
  group_by(death_event) \%>\% 
  diagnose_outlier() 
}

}
\seealso{
\code{\link{diagnose_outlier.tbl_dbi}}, \code{\link{diagnose.data.frame}}, \code{\link{diagnose_category.data.frame}}, \code{\link{diagnose_numeric.data.frame}}.
}
