% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/range_size2.R
\name{area.calc.flex}
\alias{area.calc.flex}
\title{Flexible Area Calculation for Raster}
\usage{
area.calc.flex(
  r1,
  r2_raster = NULL,
  r2_vector = NULL,
  threshold = NULL,
  zonal_polys = NULL,
  id_col = NULL,
  omit_zero = TRUE,
  unit = "km"
)
}
\arguments{
\item{r1}{The primary SpatRaster with integer categories.}

\item{r2_raster}{An optional SpatRaster for overlay analysis.}

\item{r2_vector}{An optional SpatVector for overlay analysis.}

\item{threshold}{A numeric value required to binarize 'r2_raster' if it's continuous.}

\item{zonal_polys}{An optional SpatVector for zonal analysis.}

\item{id_col}{A string specifying the column in 'zonal_polys'.}

\item{omit_zero}{A logical value. If TRUE (default), results for category = 0 are removed.}

\item{unit}{A string specifying the area unit ("km", "m", or "ha").}
}
\value{
A data frame with the area for each category.
}
\description{
This function calculates the area of integer categories in a primary raster (r1).
It can optionally compute an overlay area with a second layer (r2) and/or
perform calculations within distinct zones defined by a polygon SpatVector.
}
\examples{
\donttest{
library(terra)

# 1) Primary raster (integer categories)
land_cover <- rast(ncol = 30, nrow = 30,
                   xmin = -50, xmax = -49,
                   ymin = -15, ymax = -14)
values(land_cover) <- sample(1:3, ncell(land_cover), replace = TRUE)
crs(land_cover) <- "+proj=longlat +datum=WGS84 +no_defs"

# Basic: total area by category
area.calc.flex(land_cover, unit = "km")

# 2) Zonal polygons (two regions)
region1 <- vect("POLYGON ((-50 -15, -49.5 -15, -49.5 -14, -50 -14, -50 -15))")
region2 <- vect("POLYGON ((-49.5 -15, -49 -15, -49 -14, -49.5 -14, -49.5 -15))")
regions <- rbind(region1, region2)
crs(regions) <- crs(land_cover)
regions$region_id <- c("A", "B")

area.calc.flex(
  land_cover,
  zonal_polys = regions,
  id_col = "region_id",
  unit = "km"
)

# 3) Overlay raster (binary mask)
protected <- rast(land_cover)
values(protected) <- sample(0:1, ncell(protected), replace = TRUE)

area.calc.flex(
  land_cover,
  r2_raster = protected,
  unit = "km"
)
}
}
