% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{readDicom}
\alias{readDicom}
\alias{convertDicom}
\alias{sortDicom}
\alias{scanDicom}
\title{Read one or more DICOM directories}
\usage{
readDicom(path = ".", subset = NULL, flipY = TRUE, crop = FALSE,
  forceStack = FALSE, verbosity = 0L, labelFormat = "T\%t_N\%n_S\%s",
  depth = 5L, interactive = base::interactive(), output = NULL)

convertDicom(path = ".", subset = NULL, flipY = TRUE, crop = FALSE,
  forceStack = FALSE, verbosity = 0L, labelFormat = "T\%t_N\%n_S\%s",
  depth = 5L, interactive = base::interactive(), output = path)

sortDicom(path = ".", forceStack = FALSE, verbosity = 0L,
  labelFormat = "T\%t_N\%n_S\%s/\%b", depth = 5L, nested = NA,
  keepUnsorted = FALSE, output = path)

scanDicom(path = ".", forceStack = FALSE, verbosity = 0L,
  labelFormat = "T\%t_N\%n_S\%s", depth = 5L)
}
\arguments{
\item{path}{A character vector of paths to scan for DICOM files. Each will
examined in turn. The default is the current working directory.
\code{readDicom} (only) will accept paths to individual DICOM files,
rather than directories. Alternatively, for \code{readDicom} and
\code{sortDicom}, a data frame like the one returned by \code{scanDicom},
from which file paths will be read.}

\item{subset}{If \code{path} is a data frame, an expression which will be
evaluated in the context of the data frame to determine which series to
convert. Should evaluate to a logical vector. If \code{path} is a
character vector, \code{scanDicom} is called on the path(s) first to
produce the data frame. If this is specified, and does not evaluate to
\code{NULL}, the read will be noninteractive, irrespective of the value of
the \code{interactive} argument.}

\item{flipY}{If \code{TRUE}, the default, then images will be flipped in the
Y-axis. This is usually desirable, given the difference between
orientation conventions in the DICOM and NIfTI-1 formats.}

\item{crop}{If \code{TRUE}, then \code{dcm2niix} will attempt to crop excess
neck slices from brain images.}

\item{forceStack}{If \code{TRUE}, images with the same series number will
always be stacked together as long as their dimensions are compatible. If
\code{FALSE}, the default, images will be separated if they differ in
echo, coil or exposure number, echo time, protocol name or orientation.}

\item{verbosity}{Integer value between -2 and 3, controlling the amount of
output generated during the conversion. A value of -1 will suppress all
output from \code{dcm2niix} except warnings and errors; -2 also suppresses
warnings.}

\item{labelFormat}{A \code{\link{sprintf}}-style string specifying the
format to use for the final image labels or paths. See Details.}

\item{depth}{The maximum subdirectory depth in which to search for DICOM
files, relative to each \code{path}.}

\item{interactive}{If \code{TRUE}, the default in interactive sessions, the
requested paths will first be scanned and a list of DICOM series will be
presented. You may then choose which series to convert.}

\item{output}{The directory to write converted or copied NIfTI files to, or
\code{NULL}. In the latter case, which isn't valid for \code{sortDicom},
images are converted in memory and returned as R objects.}

\item{nested}{For \code{sortDicom}, should the sorted files be created
within the source directory (\code{TRUE}), or in the current working
directory (\code{FALSE})? Now soft-deprecated in favour of \code{output},
which is more flexible.}

\item{keepUnsorted}{For \code{sortDicom}, should the unsorted files be left
in place, or removed after they are copied into their new locations? The
default, \code{FALSE}, corresponds to a move rather than a copy. If
creating new files fails then the old ones will not be deleted.}
}
\value{
\code{readDicom} and \code{convertDicom} return a list of
\code{niftiImage} objects if \code{output} is \code{NULL}; otherwise
(invisibly) a vector of paths to NIfTI-1 files created in the target
directory. Returned images typically have attributes containing additional
metadata extracted from the DICOM headers, either in a JSON string or (if
the \code{jsonlite} package is available), in individually parsed
elements. The \code{scanDicom} function returns a data frame containing
information about each DICOM series found. \code{sortDicom} is mostly
called for its side-effect, but also (invisibly) returns a list detailing
source and target paths.
}
\description{
These functions are R wrappers around the DICOM-to-NIfTI conversion routines
provided by \code{dcm2niix}. They scan directories containing DICOM files,
potentially pertaining to more than one image series, read them and/or merge
them into a list of \code{niftiImage} objects.
}
\details{
The \code{scanDicom} function parses directories full of DICOM files and
returns information about the acquisition series they contain.
\code{readDicom} reads these files and converts them to (internal) NIfTI
images (whose pixel data can be extracted using \code{as.array}).
\code{convertDicom} performs the same conversion but writes to NIfTI files
by default, instead of retaining the images in memory. \code{sortDicom}
renames the files, but does not convert them.

The \code{labelFormat} argument describes the string format used for image
labels and sorted files. Valid codes, each escaped with a percentage sign,
include \code{a} for coil number, \code{b} for the source file base name,
\code{c} for image comments, \code{d} for series description, \code{e} for
echo number, \code{f} for the source directory, \code{i} for patient ID,
\code{j} for the series instance UID, \code{k} for the study instance UID,
\code{l} for the procedure step description, \code{m} for manufacturer,
\code{n} for patient name, \code{p} for protocol name, \code{q} for
scanning sequence, \code{r} for instance number, \code{s} for series number,
\code{t} for the date and time, \code{u} for acquisition number, \code{v}
for vendor, \code{x} for study ID and \code{z} for sequence name. For
\code{sortDicom} the label forms the new file path, and may include one or
more slashes to create subdirectories. A ".dcm" suffix will be added to file
names if no extension is specified.
}
\examples{
path <- system.file("extdata", "raw", package="divest")
scanDicom(path)
readDicom(path, interactive=FALSE)
}
\author{
Jon Clayden \href{mailto:code@clayden.org}{code@clayden.org}
}
