% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ent_similarity.R
\name{ent_similarity}
\alias{ent_similarity}
\alias{ent_similarity.numeric}
\alias{ent_similarity.species_distribution}
\title{Similarity-Based Entropy of a Community}
\usage{
ent_similarity(x, similarities, q = 1, ...)

\method{ent_similarity}{numeric}(
  x,
  similarities = diag(length(x)),
  q = 1,
  estimator = c("UnveilJ", "Max", "ChaoShen", "MarconZhang", "UnveilC", "UnveiliC",
    "naive"),
  probability_estimator = c("Chao2015", "Chao2013", "ChaoShen", "naive"),
  unveiling = c("geometric", "uniform", "none"),
  jack_alpha = 0.05,
  jack_max = 10,
  coverage_estimator = c("ZhangHuang", "Chao", "Turing", "Good"),
  sample_coverage = NULL,
  as_numeric = FALSE,
  ...,
  check_arguments = TRUE
)

\method{ent_similarity}{species_distribution}(
  x,
  similarities = diag(sum(!colnames(x) \%in\% non_species_columns)),
  q = 1,
  estimator = c("UnveilJ", "Max", "ChaoShen", "MarconZhang", "UnveilC", "UnveiliC",
    "naive"),
  probability_estimator = c("Chao2015", "Chao2013", "ChaoShen", "naive"),
  unveiling = c("geometric", "uniform", "none"),
  jack_alpha = 0.05,
  jack_max = 10,
  coverage_estimator = c("ZhangHuang", "Chao", "Turing", "Good"),
  gamma = FALSE,
  as_numeric = FALSE,
  ...,
  check_arguments = TRUE
)
}
\arguments{
\item{x}{An object, that may be a numeric vector containing abundances or probabilities,
or an object of class \link{abundances} or \link{probabilities}.
If it is a numeric vector, then its length must equal the dimensions of the
\code{similarities} matrix: species are assumed to be in the same order.}

\item{similarities}{a similarity matrix, that can be obtained by \link{fun_similarity}.
Its default value is the identity matrix.}

\item{q}{a number: the order of diversity.}

\item{...}{Unused.}

\item{estimator}{An estimator of entropy.}

\item{probability_estimator}{a string containing one of the possible estimators
of the probability distribution (see \link{probabilities}).
Used only for extrapolation.}

\item{unveiling}{a string containing one of the possible unveiling methods
to estimate the probabilities of the unobserved species (see \link{probabilities}).
Used only for extrapolation.}

\item{jack_alpha}{the risk level, 5\% by default, used to optimize the jackknife order.}

\item{jack_max}{the highest jackknife order allowed. Default is 10.}

\item{coverage_estimator}{an estimator of sample coverage used by \link{coverage}.}

\item{sample_coverage}{the sample coverage of \code{x} calculated elsewhere.
Used to calculate the gamma diversity of meta-communities, see details.}

\item{as_numeric}{if \code{TRUE}, a number or a numeric vector is returned rather than a tibble.}

\item{check_arguments}{if \code{TRUE}, the function arguments are verified.
Should be set to \code{FALSE} to save time when the arguments have been checked elsewhere.}

\item{gamma}{if \code{TRUE}, \eqn{\gamma} diversity, i.e. diversity of the metacommunity, is computed.}
}
\value{
A tibble with the site names, the estimators used and the estimated entropy.
}
\description{
Estimate the entropy of species from abundance or probability data and a
similarity matrix between species.
Several estimators are available to deal with incomplete sampling.
Bias correction requires the number of individuals.
}
\details{
All species of the \code{species_distribution} must be found in the matrix of
\code{similarities} if it is named.
If it is not or if \code{x} is numeric, its size must equal the number of species.
Then, the order of species is assumed to be the same as that of the
\code{species_distribution} or its numeric equivalent.

Similarity-Based entropy can't be interpolated of extrapolated as of the
state of the art.
}
\examples{
# Similarity matrix
Z <- fun_similarity(paracou_6_fundist)
# Diversity of each community
ent_similarity(paracou_6_abd, similarities = Z, q = 2)
# gamma diversity
ent_similarity(paracou_6_abd, similarities = Z, q = 2, gamma = TRUE)

}
