% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rightparetolognormal.R
\name{rightparetolognormal}
\alias{rightparetolognormal}
\alias{drightparetolognormal}
\alias{prightparetolognormal}
\alias{qrightparetolognormal}
\alias{mrightparetolognormal}
\alias{rrightparetolognormal}
\title{The Right-Pareto Lognormal distribution}
\usage{
drightparetolognormal(
  x,
  shape2 = 1.5,
  meanlog = -0.5,
  sdlog = 0.5,
  log = FALSE
)

prightparetolognormal(
  q,
  shape2 = 1.5,
  meanlog = -0.5,
  sdlog = 0.5,
  lower.tail = TRUE,
  log.p = FALSE
)

qrightparetolognormal(
  p,
  shape2 = 1.5,
  meanlog = -0.5,
  sdlog = 0.5,
  lower.tail = TRUE,
  log.p = FALSE
)

mrightparetolognormal(
  r = 0,
  truncation = 0,
  shape2 = 1.5,
  meanlog = -0.5,
  sdlog = 0.5,
  lower.tail = TRUE
)

rrightparetolognormal(
  n,
  shape2 = 1.5,
  meanlog = -0.5,
  sdlog = 0.5,
  lower.tail = TRUE
)
}
\arguments{
\item{x, q}{vector of quantiles}

\item{shape2, meanlog, sdlog}{Shape, mean and variance of the Right-Pareto Lognormal distribution respectively.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities (moments) are \eqn{P[X \le x]} \eqn{(E[x^r|X \le y])}, otherwise, \eqn{P[X > x]} \eqn{(E[x^r|X > y])}}

\item{p}{vector of probabilities}

\item{r}{rth raw moment of the Pareto distribution}

\item{truncation}{lower truncation parameter, defaults to xmin}

\item{n}{number of observations}
}
\value{
drightparetolognormal gives the density, prightparetolognormal gives the distribution function, qrightparetolognormal gives the quantile function, mrightparetolognormal gives the rth moment of the distribution and rrightparetolognormal generates random deviates.

 The length of the result is determined by n for rrightparetolognormal, and is the maximum of the lengths of the numerical arguments for the other functions.
}
\description{
Density, distribution function, quantile function and random generation for the Right-Pareto Lognormal distribution.
}
\details{
Probability and Cumulative Distribution Function as provided by \insertCite{reed2004double}{distributionsrd}:

 \eqn{f(x) = shape2 \omega^{-shape2-1}e^{shape2 meanlog + \frac{shape2^2sdlog^2}{2}}\Phi(\frac{lnx - meanlog - shape2 sdlog^2}{sdlog}), \newline F_X(x) = \Phi(\frac{lnx - meanlog }{sdlog}) -  \omega^{-shape2}e^{shape2 meanlog + \frac{shape2^2sdlog^2}{2}}\Phi(\frac{lnx - meanlog - shape2 sdlog^2}{sdlog})}

 The y-bounded r-th raw moment of the Right-Pareto Lognormal distribution equals:

 \eqn{meanlog^{r}_{y} = -shape2e^{shape2 meanlog + \frac{shape2^2sdlog^2}{2}}\frac{y^{\sigma_s - shape2-1}}{\sigma_s - shape2 - 1}\Phi(\frac{lny - meanlog - shape2 sdlog^2}{sdlog}) \newline \qquad - \frac{shape2}{r-shape2} e^{\frac{ r^2sdlog^2 + 2meanlog r }{2}}\Phi^c(\frac{lny -  rsdlog^2 + meanlog}{sdlog}),  \qquad shape2>r}
}
\examples{

## Right-Pareto Lognormal density
plot(x = seq(0, 5, length.out = 100), y = drightparetolognormal(x = seq(0, 5, length.out = 100)))
plot(x = seq(0, 5, length.out = 100), y = drightparetolognormal(x = seq(0, 5, length.out = 100),
shape2 = 1))

## Right-Pareto Lognormal relates to the Lognormal if the shape parameter goes to infinity
prightparetolognormal(q = 6, shape2 = 1e20, meanlog = -0.5, sdlog = 0.5)
plnorm(q = 6, meanlog = -0.5, sdlog = 0.5)

## Demonstration of log functionality for probability and quantile function
qrightparetolognormal(prightparetolognormal(2, log.p = TRUE), log.p = TRUE)

## The zeroth truncated moment is equivalent to the probability function
prightparetolognormal(2)
mrightparetolognormal(truncation = 2)

## The (truncated) first moment is equivalent to the mean of a (truncated) random sample,
#for large enough samples.
x <- rrightparetolognormal(1e5, shape2 = 3)

mean(x)
mrightparetolognormal(r = 1, shape2 = 3, lower.tail = FALSE)

sum(x[x > quantile(x, 0.1)]) / length(x)
mrightparetolognormal(r = 1, shape2 = 3, truncation = quantile(x, 0.1), lower.tail = FALSE)
}
\references{
\insertAllCited{}
}
