% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lefttparetolognormal.R
\name{leftparetolognormal}
\alias{leftparetolognormal}
\alias{dleftparetolognormal}
\alias{pleftparetolognormal}
\alias{qleftparetolognormal}
\alias{mleftparetolognormal}
\alias{rleftparetolognormal}
\title{The Left-Pareto Lognormal distribution}
\usage{
dleftparetolognormal(x, shape1 = 1.5, meanlog = -0.5, sdlog = 0.5, log = FALSE)

pleftparetolognormal(
  q,
  shape1 = 1.5,
  meanlog = -0.5,
  sdlog = 0.5,
  lower.tail = TRUE,
  log.p = FALSE
)

qleftparetolognormal(
  p,
  shape1 = 1.5,
  meanlog = -0.5,
  sdlog = 0.5,
  lower.tail = TRUE,
  log.p = FALSE
)

mleftparetolognormal(
  r = 0,
  truncation = 0,
  shape1 = 1.5,
  meanlog = -0.5,
  sdlog = 0.5,
  lower.tail = TRUE
)

rleftparetolognormal(n, shape1 = 1.5, meanlog = -0.5, sdlog = 0.5)
}
\arguments{
\item{x, q}{vector of quantiles}

\item{shape1, meanlog, sdlog}{Shape, mean and variance of the Left-Pareto Lognormal distribution respectively.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities (moments) are \eqn{P[X \le x]} \eqn{(E[x^r|X \le y])}, otherwise, \eqn{P[X > x]} \eqn{(E[x^r|X > y])}}

\item{p}{vector of probabilities}

\item{r}{rth raw moment of the Pareto distribution}

\item{truncation}{lower truncation parameter, defaults to xmin}

\item{n}{number of observations}
}
\value{
dleftparetolognormal gives the density, pleftparetolognormal gives the distribution function, qleftparetolognormal gives the quantile function, mleftparetolognormal gives the rth moment of the distribution and rleftparetolognormal generates random deviates.

 The length of the result is determined by n for rleftparetolognormal, and is the maximum of the lengths of the numerical arguments for the other functions.
}
\description{
Density, distribution function, quantile function and random generation for the Left-Pareto Lognormal distribution.
}
\details{
Probability and Cumulative Distribution Function as provided by \insertCite{reed2004double}{distributionsrd}:

 \eqn{f(x) = shape1\omega^{shape1-1}e^{-shape1 meanlog + \frac{shape1^2sdlog^2}{2}}\Phi^c(\frac{ln\omega - meanlog +shape1 sdlog^2}{sdlog}), \newline F_X(x) = \Phi(\frac{ln\omega - meanlog }{sdlog}) -  		\omega^{shape1}e^{-shape1 meanlog + \frac{shape1^2sdlog^2}{2}}\Phi^c(\frac{ln\omega - meanlog +shape1 sdlog^2}{sdlog})}

 The y-bounded r-th raw moment of the Let-Pareto Lognormal distribution equals:

 \eqn{meanlog^{r}_{y} = -shape1e^{-shape1 meanlog + \frac{shape1^2sdlog^2}{2}}\frac{y^{\sigma_s + shape1-1}}{\sigma_s + shape1 - 1}\Phi^c(\frac{lny - meanlog + shape1 sdlog^2}{sdlog}) \newline \qquad + \frac{shape1}{r+shape1} e^{\frac{ r^2sdlog^2 + 2meanlog r }{2}}\Phi^c(\frac{lny -  rsdlog^2 + meanlog}{sdlog})}
}
\references{
\insertAllCited{}

 ## Left-Pareto Lognormal density
 plot(x=seq(0,5,length.out=100),y=dleftparetolognormal(x=seq(0,5,length.out=100)))
 plot(x=seq(0,5,length.out=100),y=dleftparetolognormal(x=seq(0,5,length.out=100),shape1=1))

 ## Left-Pareto Lognormal relates to the Lognormal if the shape parameter goes to infinity
 pleftparetolognormal(q=6,shape1=1e20,meanlog=-0.5,sdlog=0.5)
 plnorm(q=6,meanlog=-0.5,sdlog=0.5)

 ## Demonstration of log functionality for probability and quantile function
 qleftparetolognormal(pleftparetolognormal(2,log.p=TRUE),log.p=TRUE)

 ## The zeroth truncated moment is equivalent to the probability function
 pleftparetolognormal(2)
 mleftparetolognormal(truncation=2)

 ## The (truncated) first moment is equivalent to the mean of a (truncated) random sample,
 #for large enough samples.
 x = rleftparetolognormal(1e5)

 mean(x)
 mleftparetolognormal(r=1,lower.tail=FALSE)

 sum(x[x>quantile(x,0.1)])/length(x)
 mleftparetolognormal(r=1,truncation=quantile(x,0.1),lower.tail=FALSE)
}
