% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/burr.R
\name{burr_plt}
\alias{burr_plt}
\title{Burr coefficients after power-law transformation}
\usage{
burr_plt(shape1 = 2, shape2 = 1, scale = 0.5, a = 1, b = 1, inv = FALSE)
}
\arguments{
\item{shape1, shape2, scale}{Shape1, shape2 and scale of the Burr distribution, defaults to 2, 1 and 1 respectively.}

\item{a, b}{constant and power of power-law transformation, defaults to 1 and 1 respectively.}

\item{inv}{logical indicating whether coefficients of the outcome variable of the power-law transformation should be returned (FALSE) or whether coefficients of the input variable being power-law transformed should be returned (TRUE). Defaults to FALSE.}
}
\value{
Returns a named list containing
\describe{
\item{coefficients}{Named vector of coefficients}
}

 ## Comparing probabilites of power-law transformed transformed variables
 pburr(3,shape1=2,shape2=3,scale=1)
 coeff = burr_plt(shape1=2,shape2=3,scale=1,a=5,b=7)$coefficients
 pburr(5*3^7,shape1=coeff[["shape1"]],shape2=coeff[["shape2"]],scale=coeff[["scale"]])

 pburr(5*0.9^7,shape1=2,shape2=3,scale=1)
 coeff = burr_plt(shape1=2,shape2=3,scale=1,a=5,b=7, inv=TRUE)$coefficients
 pburr(0.9,shape1=coeff[["shape1"]],shape2=coeff[["shape2"]],scale=coeff[["scale"]])

 ## Comparing the first moments and sample means of power-law transformed variables for large enough samples
 x = rburr(1e5,shape1=2,shape2=3,scale=1)
 coeff = burr_plt(shape1=2,shape2=3,scale=1,a=2,b=0.5)$coefficients
 y = rburr(1e5,shape1=coeff[["shape1"]],shape2=coeff[["shape2"]],scale=coeff[["scale"]])
 mean(2*x^0.5)
 mean(y)
 mburr(r=1,shape1=coeff[["shape1"]],shape2=coeff[["shape2"]],scale=coeff[["scale"]],lower.tail=FALSE)
}
\description{
Coefficients of a power-law transformed Burr distribution
}
\details{
If the random variable x is Burr distributed with scale shape and shape scale, then the power-law transformed variable

 \deqn{ y = ax^b }

 is Burr distributed with shape1 \eqn{shape1}, shape2 \eqn{b*shape2} and scale \eqn{ ( \frac{scale}{a})^{\frac{1}{b}} }.
}
