% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/burr.R
\name{burr}
\alias{burr}
\alias{dburr}
\alias{pburr}
\alias{qburr}
\alias{mburr}
\alias{rburr}
\title{The Burr distribution}
\usage{
dburr(x, shape1 = 2, shape2 = 1, scale = 0.5, log = FALSE)

pburr(q, shape1 = 2, shape2 = 1, scale = 0.5, log.p = FALSE, lower.tail = TRUE)

qburr(p, shape1 = 2, shape2 = 1, scale = 0.5, log.p = FALSE, lower.tail = TRUE)

mburr(
  r = 0,
  truncation = 0,
  shape1 = 2,
  shape2 = 1,
  scale = 0.5,
  lower.tail = TRUE
)

rburr(n, shape1 = 2, shape2 = 1, scale = 0.5)
}
\arguments{
\item{x, q}{vector of quantiles}

\item{shape1, shape2, scale}{Shape1, shape2 and scale of the Burr distribution, defaults to 2, 1 and 0.5.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities (moments) are \eqn{P[X \le x]} \eqn{(E[x^r|X \le y])}, otherwise, \eqn{P[X > x]} \eqn{(E[x^r|X > y])}}

\item{p}{vector of probabilities}

\item{r}{rth raw moment of the distribution}

\item{truncation}{lower truncation parameter}

\item{n}{number of observations}
}
\value{
dburr returns the density, pburr the distribution function, qburr the quantile function, mburr the rth moment of the distribution and rburr generates random deviates.

 The length of the result is determined by n for rburr, and is the maximum of the lengths of the numerical arguments for the other functions.
}
\description{
Density, distribution function, quantile function, raw moments and random generation for the Burr distribution, also known as the Burr Type XII distribution or the Singh-Maddala distribution.
}
\details{
Probability and Cumulative Distribution Function:

 \deqn{f(x) =\frac{\frac{kc}{scale}(\frac{\omega}{scale})^{shape2-1}}{(1+(\frac{\omega}{scale})^shape2)^{shape1+1}}, \qquad F_X(x) = 1-\frac{1}{(1+(\frac{\omega}{scale})^shape2)^shape1}}

 The y-bounded r-th raw moment of the Fréchet distribution equals:

 \deqn{scale^{r} shape1 [\boldsymbol{B}(\frac{r}{shape2} +1,shape1-\frac{r}{shape2}) - \boldsymbol{B}(\frac{(\frac{y}{scale})^{shape2}}{1+(\frac{y}{scale})^{shape2}};\frac{r}{shape2} +1,shape1-\frac{r}{shape2})],  \qquad shape2>r, kc>r}
}
\examples{

## Burr density
plot(x = seq(0, 5, length.out = 100), y = dburr(x = seq(0, 5, length.out = 100)))
plot(x = seq(0, 5, length.out = 100), y = dburr(x = seq(0, 5, length.out = 100), shape2 = 3))

## Demonstration of log functionality for probability and quantile function
qburr(pburr(2, log.p = TRUE), log.p = TRUE)

## The zeroth truncated moment is equivalent to the probability function
pburr(2)
mburr(truncation = 2)

## The (truncated) first moment is equivalent to the mean of a
#(truncated) random sample, for large enough samples.
x <- rburr(1e5, shape2 = 3)

mean(x)
mburr(r = 1, shape2 = 3, lower.tail = FALSE)

sum(x[x > quantile(x, 0.1)]) / length(x)
mburr(r = 1, shape2 = 3, truncation = quantile(x, 0.1), lower.tail = FALSE)
}
