% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/medoids.R
\name{find_medoids}
\alias{find_medoids}
\title{Finds the medoids from a distance matrix}
\usage{
find_medoids(D, memberships = NULL)
}
\arguments{
\item{D}{An object of class \code{\link[stats:dist]{stats::dist}}.}

\item{memberships}{A factor specifying the cluster memberships of the
objects.}
}
\value{
A named integer vector specifying the indices of the medoids.
}
\description{
This function finds the medoids from a distance matrix. The
medoid is the object that minimizes the sum of distances to all other
objects. This function takes advantage of the \strong{RcppParallel} package to
compute the medoids in parallel.
}
\examples{
D <- stats::dist(iris[, 1:4])
find_medoids(D)
memberships <- as.factor(rep(1:3, each = 50L))
find_medoids(D, memberships)
}
