\name{confint.distfreereg}
\alias{confint.distfreereg}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
	Calculate confidence intervals with a \code{distfreereg} object
}
\description{
	This is a \code{\link{confint}} method for objects of class \code{distfreereg}. It calculates confidence intervals for the estimated parameters of a model in a \code{distfreereg} object.
}
\usage{
	\method{confint}{distfreereg}(object, parm, level = 0.95, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{object}{
	Object of class \code{distfreereg}.
}
  \item{parm}{
	Numeric or character vector; specifies which parameters are to be given confidence intervals. If missing, all parameters are considered.
}
  \item{level}{
	Numeric vector of length one; specifies the confidence level.
}
  \item{\dots}{
	Additional parameters passed to other methods. Currently ignored.
}
}
\details{
	When \code{object} contains a model object (either in the \code{test_mean} or \code{model} element), then this model is sent to \code{\link{confint}}. Otherwise, \code{object} is sent to \code{\link{confint.default}}.
}
\note{
	If \code{object} was created by calling \code{\link{distfreereg.default}} directly, there is no estimated parameter vector, and therefore \code{confint.distfreereg} does not apply.
}
\value{
	The output from the appropriate \code{\link{confint}} method.
}
\author{
	Jesse Miller
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
	\code{\link{distfreereg}}, \code{\link{vcov.distfreereg}}, \code{\link{confint}}
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory (show via RShowDoc("KEYWORDS")):
% \keyword{ ~kwd1 }
% \keyword{ ~kwd2 }
% Use only one keyword per line.
% For non-standard keywords, use \concept instead of \keyword:
% \concept{ ~cpt1 }
% \concept{ ~cpt2 }
% Use only one concept per line.
