validate_args_distfreereg_default <-
  function(Y, X, covariance, ordering, J, fitted_values, stat, B, group,
           override, verbose, control, extra_arg_list){
    
    validate_extra_arg_list(extra_arg_list, "distfreereg.default()")
    
    if(!is.null(control))
      validate_named_list(control, valid_names = c("matsqrt_tol", "solve_tol",
                                                   "qr_tol", "orth_tol",
                                                   "trans_tol", "sym_tol",
                                                   "sym_tol1",
                                                   "return_on_error", "data"))
    
    control <- combine_lists(control,
                             list(return_on_error = TRUE),
                             default_distfreereg_tol())
    validate_control_tols(control)
    
    return_on_error <- control[["return_on_error"]]
    if(!isTRUE(return_on_error) && !isFALSE(return_on_error))
      stop("control[['return_on_error']] must be TRUE or FALSE")
    
    Y <- validate_Y(Y = Y, verbose = verbose)
    n <- length(Y)
    
    X <- validate_X(X = X, verbose = verbose)
    
    
    
    # Verify that override is a named list.
    if(!is.null(override)){
      validate_named_list(override, valid_names = c("res_order", "r", "mcsim_stats"))
      
      if(!is.null(override[["res_order"]])){
        if(!isOrdering(override[["res_order"]], len = n)) stop("override[['res_order']] must be an ordering")
      }
      
      if(!is.null(override[["r"]])){
        validate_numeric(override[["r"]], message = "override[['r']] failed numeric validation: ")
        if(nrow(as.matrix(override[["r"]])) != n) stop("nrow(as.matrix(override[['r']])) must be equal to length(Y)") 
      }
    }
    
    validate_numeric(J, message = "J failed numeric validation: ")
    J <- as.matrix(J)
    if(nrow(as.matrix(J)) != n) stop("nrow(as.matrix(J)) must be equal to length(Y)") 
    
    validate_numeric(fitted_values, len = n,
                     message = "Fitted values failed numeric validation: ")
    
    
    # Verify that X and Y dimensions match.
    if(!is.null(X) && nrow(X) != n)
      stop("The number of rows in X must be the length of Y: nrow(X) is ",
           nrow(X), ", but length(Y) is ", n)
    
    # Verify covariance list.
    validate_covariance_list(covariance, n = n, sym_tol = control[["sym_tol"]],
                             sym_tol1 = control[["sym_tol1"]])
    
    
    # Validate B
    validate_numeric(x = B, pos_int = TRUE, len = 1)
    B <- as.integer(B)
    
    
    # Validate the observation ordering specification.
    if(is.null(override[["res_order"]])){
      if(is.list(ordering)){
        if(!is.null(control[["data"]])){
          validate_order_columns(control[["data"]], ordering)
        } else {
          validate_order_columns(X, ordering)
        }
      } else {
        if(length(ordering) > 1) stop("ordering method specification must have length one, ",
                                      "or be a list of column specifications")
        strict_match(ordering, c("asis", "optimal", "simplex", "natural"))
      }
    }
    
    # Validate 'group'
    if(!isTRUE(group) && !isFALSE(group)) stop("'group' must be TRUE or FALSE")

    # Check stat functions for egregious errors.
    v <- vector(mode = "list", length = length(stat))
    for(i in seq_along(stat)){
      v[[i]] <- tryCatch(get(stat[i])(rnorm(100)),
                         error = function(e) stop("Unable to evaluate ",
                                                  deparse1(substitute(stat[i])),
                                                  "(rnorm(100)): ", e))
    }
    bad_ind <- which(sapply(v, function(x) isFALSE(is.numeric(x)) ||
                              isFALSE(length(x) == 1)))
    if(length(bad_ind) > 0){
      stop("The following stat functions are invalid: ",
           paste(stat[bad_ind], collapse = ", "), ".\nEach failed either ",
           "because it did not return a (non-NA) numeric value or because its ",
           "output is not a single number.")
    }
    return(list(Y = Y, X = X, n = n, J = J, covariance = covariance,
                matsqrt_tol = control[["matsqrt_tol"]], solve_tol = control[["solve_tol"]],
                qr_tol = control[["qr_tol"]], orth_tol = control[["orth_tol"]],
                trans_tol = control[["trans_tol"]],
                sym_tol = control[["sym_tol"]],
                sym_tol1 = control[["sym_tol1"]],
                B = B,
                return_on_error = return_on_error))
  }
