% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/momentum_spatial.R
\name{momentum_spatial}
\alias{momentum_spatial}
\title{Spatial Representation of \code{momentum()} Data Frames}
\usage{
momentum_spatial(df = NULL, sf = NULL, network = TRUE)
}
\arguments{
\item{df}{(required, data frame) Output of \code{\link[=momentum]{momentum()}}, \code{\link[=momentum_ls]{momentum_ls()}}, or \code{\link[=momentum_dtw]{momentum_dtw()}}. Default: NULL}

\item{sf}{(required, sf data frame) Points or polygons representing the location of the time series in argument 'df'. It must have a column with all time series names in \code{df$x} and \code{df$y}. Default: NULL}

\item{network}{(optional, logical) If TRUE, the resulting sf data frame is of time LINESTRING and represent network edges. Default: TRUE}
}
\value{
sf data frame (LINESTRING geometry)
}
\description{
Given an sf data frame with geometry types POLYGON, MULTIPOLYGON, or POINT representing time series locations, this function transforms the output of \code{\link[=momentum]{momentum()}}, \code{\link[=momentum_ls]{momentum_ls()}}, \code{\link[=momentum_dtw]{momentum_dtw()}} to an sf data frame.

If \code{network = TRUE}, the sf data frame is of type LINESTRING, with edges connecting time series locations. This output is helpful to build many-to-many dissimilarity maps (see examples).

If \code{network = FALSE}, the sf data frame contains the geometry in the input \code{sf} argument. This output helps build one-to-many dissimilarity maps.
}
\examples{
tsl <- distantia::tsl_initialize(
  x = distantia::eemian_pollen,
  name_column = "name",
  time_column = "time"
) |>
#reduce size to speed-up example runtime
distantia::tsl_subset(
  names = 1:3
  )

df_momentum <- distantia::momentum(
  tsl = tsl
)

#network many to many
sf_momentum <- distantia::momentum_spatial(
  df = df_momentum,
  sf = distantia::eemian_coordinates,
  network = TRUE
)

#network map
# mapview::mapview(
#   sf_momentum,
#   layer.name = "Importance - Abies",
#   label = "edge_name",
#   zcol = "importance__Abies",
#   lwd = 3
# ) |>
#   suppressWarnings()

}
\seealso{
Other momentum_support: 
\code{\link{momentum_aggregate}()},
\code{\link{momentum_boxplot}()},
\code{\link{momentum_model_frame}()},
\code{\link{momentum_stats}()},
\code{\link{momentum_to_wide}()}
}
\concept{momentum_support}
