% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrtr-package.R
\docType{data}
\name{mc_commute_long}
\alias{mc_commute_long}
\title{McMaster Commuting Data Set (long format).}
\format{
An indexed data frame of class dfidx with 5500 rows and 62 variables:
\describe{
\item{id}{Unique identifier for respondents}
\item{choice}{Mode of transportation chosen: Cycle, Walk, HSR (local transit), Car}
\item{parking}{Indicator variable for holding a university parking permit: Yes/No}
\item{vehind}{Indicator variable for having individual access to a private car (i.e., car not shared with other household members): Yes/No}
\item{gender}{Woman/Man}
\item{age}{Age in years}
\item{shared}{Indicator variable for Indicator variable for a student living in a rental property with other students, i.e., living in shared accommodations}
\item{family}{Indicator variable for living in family home}
\item{child}{Indicator variable for presence of dependent minors in household: Yes/No}
\item{street_density}{Street density in the dissemination area of the place of residence in $km/km^2$}
\item{sidewalk_density}{Sidewalk density in the dissemination area of the place of residence in $km/km^2$}
\item{LAT}{Latitude of the place or residence, geocoded at the nearest major intersection or centroid of 6-digit postal area}
\item{LONG}{Longitude of the place or residence, geocoded at the nearest major intersection or centroid of 6-digit postal area}
\item{PersonalVehComf_SD}{Response to statement "The personal vehicles I usually travel in are comfortable": 1 if Strongly Disagree, 0 otherwise}
\item{PersonalVehComf_D}{Response to statement "The personal vehicles I usually travel in are comfortable": 1 if Disagree, 0 otherwise}
\item{PersonalVehComf_A}{Response to statement "The personal vehicles I usually travel in are comfortable": 1 if Agree, 0 otherwise}
\item{PersonalVehComf_SA}{Response to statement "The personal vehicles I usually travel in are comfortable": 1 if Strongly Agree, 0 otherwise}
\item{Fun_SD}{Response to statement "Getting there is half the fun": 1 if Strongly Disagree, 0 otherwise}
\item{Fun_D}{Response to statement "Getting there is half the fun": 1 if Disagree, 0 otherwise}
\item{Fun_A}{Response to statement "Getting there is half the fun": 1 if Agree, 0 otherwise}
\item{Fun_SA}{Response to statement "Getting there is half the fun": 1 if Strongly Agree, 0 otherwise}
\item{ActiveNeigh_SD}{Response to statement "I like to live in a neighborhood where there's a lot going on": 1 if Strongly Disagree, 0 otherwise}
\item{ActiveNeigh_D}{Response to statement "I like to live in a neighborhood where there's a lot going on": 1 if Disagree, 0 otherwise}
\item{ActiveNeigh_A}{Response to statement "I like to live in a neighborhood where there's a lot going on": 1 if Agree, 0 otherwise}
\item{ActiveNeigh_SA}{Response to statement "I like to live in a neighborhood where there's a lot going on": 1 if Strongly Agree, 0 otherwise}
\item{UsefulTrans_SD}{Response to statement "My commute trip is a useful transition between home and school": 1 if Strongly Disagree, 0 otherwise}
\item{UsefulTrans_D}{Response to statement "My commute trip is a useful transition between home and school": 1 if Disagree, 0 otherwise}
\item{UsefulTrans_A}{Response to statement "My commute trip is a useful transition between home and school": 1 if Agree, 0 otherwise}
\item{UsefulTrans_SA}{Response to statement "My commute trip is a useful transition between home and school": 1 if Strongly Agree, 0 otherwise}
\item{BusComf_SD}{Response to statement "The buses I usually travel in are comfortable": 1 if Strongly Disagree, 0 otherwise}
\item{BusComf_D}{Response to statement "The buses I usually travel in are comfortable": 1 if Disagree, 0 otherwise}
\item{BusComf_A}{Response to statement "The buses I usually travel in are comfortable": 1 if Agree, 0 otherwise}
\item{BusComf_SA}{Response to statement "The buses I usually travel in are comfortable": 1 if Strongly Agree, 0 otherwise}
\item{TravelAlone_SD}{Response to statement "I like traveling alone": 1 if Strongly Disagree, 0 otherwise}
\item{TravelAlone_D}{Response to statement "I like traveling alone": 1 if Disagree, 0 otherwise}
\item{TravelAlone_A}{Response to statement "I like traveling alone": 1 if Agree, 0 otherwise}
\item{TravelAlone_SA}{Response to statement "I like traveling alone": 1 if Strongly Agree, 0 otherwise}
\item{Shelters_SD}{Response to statement "Shelters and other public transportation facilities that I commonly use are of good quality": 1 if Strongly Disagree, 0 otherwise}
\item{Shelters_D}{Response to statement "Shelters and other public transportation facilities that I commonly use are of good quality": 1 if Disagree, 0 otherwise}
\item{Shelters_A}{Response to statement "Shelters and other public transportation facilities that I commonly use are of good quality": 1 if Agree, 0 otherwise}
\item{Shelters_SA}{Response to statement "Shelters and other public transportation facilities that I commonly use are of good quality": 1 if Strongly Agree, 0 otherwise}
\item{Community_SD}{Response to statement "There is a sense of community in my neighborhood": 1 if Strongly Disagree, 0 otherwise}
\item{Community_D}{Response to statement "There is a sense of community in my neighborhood": 1 if Disagree, 0 otherwise}
\item{Community_A}{Response to statement "There is a sense of community in my neighborhood": 1 if Agree, 0 otherwise}
\item{Community_SA}{Response to statement "There is a sense of community in my neighborhood": 1 if Agree, 0 otherwise}
\item{personal_veh_comfortable}{Response to statement "The personal vehicles I usually travel in are comfortable" as factor: SD-Strongly Disagree, D-Disagree, N-Neutral, A-Agree, SA-Strongly Agree}
\item{getting_there_fun}{Response to statement "Getting there is half the fun" as factor: SD-Strongly Disagree, D-Disagree, N-Neutral, A-Agree, SA-Strongly Agree}
\item{like_active_neighborhood}{Response to statement "I like to live in a neighborhood where there's a lot going on" as factor: SD-Strongly Disagree, D-Disagree, N-Neutral, A-Agree, SA-Strongly Agree}
\item{commute_useful_transition}{Response to statement "My commute trip is a useful transition between home and school" as factor: SD-Strongly Disagree, D-Disagree, N-Neutral, A-Agree, SA-Strongly Agree}
\item{buses_comfortable}{Response to statement "The buses I usually travel in are comfortable" as factor: SD-Strongly Disagree, D-Disagree, N-Neutral, A-Agree, SA-Strongly Agree}
\item{prefer_travel_alone}{Response to statement "I like traveling alone" as factor: SD-Strongly Disagree, D-Disagree, N-Neutral, A-Agree, SA-Strongly Agree}
\item{shelter_good_quality}{Response to statement "Shelters and other public transportation facilities that I commonly use are of good quality" as factor: SD-Strongly Disagree, D-Disagree, N-Neutral, A-Agree, SA-Strongly Agree}
\item{sense_community}{Response to statement "There is a sense of community in my neighborhood" as factor: SD-Strongly Disagree, D-Disagree, N-Neutral, A-Agree, SA-Strongly Agree1 if Strongly Disagree, 0 otherwise}
\item{numna}{Total number of available alternatives, e.g., if bus and walk = 2, if all four = 4}
\item{alt}{A factor with the alternatives in the choice set}
\item{available}{An indicator variable for availability of the alternative}
\item{time.Cycle}{Travel time by alternative}
\item{access}{Access time to transit in minutes (i.e., reaching a transit stop)}
\item{wait}{Waiting time transit (i.e., at a transit stop)}
\item{transfer}{Number of transit transfers}
\item{idx}{Index for the table: includes chid (identifier for the choice) and alt (the alternative)}
}
}
\source{
Whalen, K. E., P\'{a}ez, A., & Carrasco, J. A. (2013). Mode choice of university students commuting to school and the role of active travel. Journal of Transport Geography, 31, 132-142. (https://doi.org/10.1016/j.jtrangeo.2013.06.008)
}
\usage{
data(mc_commute_long)
}
\description{
A data set containing information about \emph{students} commuting to McMaster University. Data were collected
by means of a travel survey in the fall of 2010. Respondents were asked about their mode of
travel to McMaster University, in Hamilton, Canada. They were also asked about the modes available
to them. The characteristics of the trips were self-reported or imputed. The data set also contains
relevant attributes about the respondents. The format of the table is long, with each row representing
a choice situation.
}
\examples{
 data(mc_commute_long)
 library(dfidx)
 print(mc_commute_long, n = 12)
}
\keyword{datasets}
