% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discovr.R
\docType{package}
\name{discovr}
\alias{discovr-package}
\alias{discovr}
\title{discovr: Resources for Discovering Statistics Using R and RStudio (Field, 2023)}
\description{
The \code{discovr} package contains interactive \code{learnr} tutorials and datasets that accompany my textbook \href{https://www.discovr.rocks/}{Discovering Statistics Using R and RStudio}.
}
\section{Who is the package aimed at?}{


Anyone teaching from or reading \href{https://www.discovr.rocks/}{Discovering Statistics Using R and RStudio} should find these resources useful.
}

\section{Interactive tutorials}{


\strong{Getting started}:

I recommend working through \href{https://milton-the-cat.rocks/learnr/r/r_getting_started/}{this tutorial} on how to install, set up and work within R and RStudio before starting the interactive tutorials.

\strong{Running a tutorial}:

To run each tutorial execute

\code{learnr::run_tutorial("name_of_tutorial", package = "discovr")}

Replacing \code{name_of_tutorial} with the name in bold below. For example, to load the tutorial \code{discovr_02} execute:

\code{learnr::run_tutorial("discovr_02", package = "discovr")}
\itemize{
\item \strong{discovr_01}: Key concepts in R (functions and objects, packages and functions, style, data types, tidyverse, tibbles)
\item \strong{discovr_02}: Summarizing data (frequency distributions, grouped frequency distributions, relative frequencies, histograms, mean, median, variance, standard deviation, interquartile range)
\item \strong{discovr_03}: Confidence intervals: interactive app demonstrating what a confidence interval is, computing normal and bootstrap confidence intervals using R, adding confidence intervals to data summaries
\item \strong{discovr_05}: Visualizing data. The \code{ggplot2} package, boxplots, plotting means, violin plots, scatterplots, grouping by colour, grouping using facets, adjusting scales, adjusting positions.
\item \strong{discovr_06}: The beast of bias. Restructuring data from messy to tidy format (and back). Spotting outliers using histograms and boxplots. Calculating \emph{z}-scores (standardizing scores). Writing your own function. Using \emph{z}-scores to detect outliers. Q-Q plots. Calculating skewness, kurtosis and the number of valid cases. Grouping summary statistics by multiple categorical/grouping variables.
\item \strong{discovr_07}: Associations. Plotting data with \code{GGally}. Pearson's \emph{r}, Spearman's Rho, Kendall's tau, robust correlations.
\item \strong{discovr_08}: The general linear model (GLM). Visualizing the data, fitting GLMs with one and two predictors. Viewing model parameters with \code{broom}, model parameters, standard errors, confidence intervals, fit statistics, significance, Bayes factors and Bayesian estimates (using default priors).
\item \strong{discovr_09}: Categorical predictors with two categories (comparing two means). Comparing two independent means, comparing two related means, effect sizes, robust comparisons of means (independent and related), Bayes factors and estimation (independent and related means).
\item \strong{discovr_10}: Moderation and mediation. Centring variables (grand mean centring), specifying interaction terms, moderation analysis, simple slopes analysis, Johnson-Neyman intervals, mediation with one predictor, direct and indirect effects, mediation using lavaan.
\item \strong{discovr_11}: Comparing several means. Essentially 'One-way independent ANOVA' but taught using a general linear model framework. Covers setting contrasts (dummy coding, contrast coding, and linear and quadratic trends), the \emph{F}-statistic and Welch's robust \emph{F}, robust parameter estimation, heteroscedasticity-consistent tests of parameters, robust tests of means based on trimmed data, \emph{post hoc} tests, Bayes factors.
\item \strong{discovr_12}: Comparing means adjusted for other variables. Essentially 'Analysis of Covariance (ANCOVA)' designs but taught using a general linear model framework. Covers setting contrasts, Type III sums of squares, the \emph{F}-statistic, robust parameter estimation, heteroscedasticity-consistent tests of parameters, robust tests of adjusted means, \emph{post hoc} tests, Bayes factors.
\item \strong{discovr_13}: Factorial designs. Fitting models for two-way factorial designs (independent measures) using both \code{lm()} and the \code{afex} package. This tutorial builds on previous ones to show how models can be fit with two categorical predictors to look at the interaction between them. We look at fitting the models, setting contrasts for the two categorical predictors, obtaining estimated marginal means, interaction plots, simple effects analysis, diagnostic plots, partial eta-squared and partial omega-squared, robust models and Bayes factors.
\item \strong{discovr_14}: Multilevel models. This tutorial looks at fitting multilevel models using the \code{lme4} package. It begins with an optional section on checking and coding categorical variables before moving on to show you how to fit and interpret a multilevel model.
\item \strong{discovr_14_lme}: Multilevel models. This tutorial looks at fitting multilevel models using the \code{nlme} package. It begins with an optional section on checking and coding categorical variables before moving on to show you how to fit and interpret a multilevel model.
\item \strong{discovr_15}: Repeated measures designs. Fitting models for one- and two-way repeated measures designs using the \code{afex} package. This tutorial builds on previous ones to show how models can be fit with one or two categorical predictors when these variables have been manipulated within the same entities. We look at fitting the models, setting contrasts for the categorical predictors, obtaining estimated marginal means, interaction plots, simple effects analysis, diagnostic plots, robust models and Bayes factors.
\item \strong{discovr_16}: Mixed designs. Fitting models for mixed designs using the \code{afex} package. This tutorial builds on previous ones to show how models can be fit with one or two categorical predictors when at least one of these variables has been manipulated within the same entities and at least one other has been manipulated using different entities. We look at fitting the models, setting contrasts for the categorical predictors, obtaining estimated marginal means, interaction plots, simple effects analysis, diagnostic plots, robust models and Bayes factors.
\item \strong{discovr_18}: Exploratory Factor Analysis (EFA). Applying factor analysis using the \code{psych} package.
}

\strong{Workflow}:

The tutorials are self-contained (you practice code in code boxes) so you don't need to use RStudio at the
same time. However, to get the most from them I would recommend that you create an RStudio project and within that open (and save) a new
R Markdown file each time to work through a tutorial. Within that Markdown file, replicate parts of the code from the tutorial (in code chunks)
and use Markdown to write notes about what you have done, and to reflect on things that you have struggled with, or note useful tips to help you
remember things. Basically, write a learning journal. This workflow has the advantage of not just teaching you the code that you need to do certain things,
but also provides practice in using RStudio itself.
}

\section{Datasets}{


See the book or data descriptions for more details. This is a list of available datasets within the package. Raw CSV files are available from the book's website.
\itemize{
\item \link{acdc}: Data about whether Bon Scott or Brian Johnson is the best singer of AC/DC.
\item \link{album_sales}: Fictitious data about predicting album sales from advertising, airplay and the band's image.
\item \link{alien_scents}: Fictitious data about training sniffer dogs to detect alien space lizards when they try to mask their identity with different scents. See also \link{sniffer_dogs}.
\item \link{angry_pigs}: fictitious data about whether playing the video game angry pigs makes people more aggressive towards pigs. See also \link{angry_real}.
\item \link{angry_real}: fictitious data about whether playing the video game angry pigs makes people more aggressive in everyday life. See also \link{angry_pigs}.
\item \link{animal_bride}: Fictitious data about life satisfaction when married to a dog or a goat.
\item \link{animal_dance}: Fictitious data about training cats and dogs to dance.
\item \link{beckham_1929}: Data from a study by Beckham (1929).
\item \link{big_hairy_spider}: Fictitious data about whether anxiety is greater after exposure to real spiders or pictures of spiders.
\item \link{biggest_liar}: Fictitious data about creativity and telling lies.
\item \link{bronstein_2019}: Data about whether delusion proneness predicts belief in fake news because of less analytic thinking.
\item \link{bronstein_miss_2019}: The data in \link{bronstein_2019} but with missing values inserted using MCAR amputation.
\item \link{catterplot}: Fictitious data for plotting a catterplot.
\item \link{cat_dance}: Fictitious data about training cats to dance.
\item \link{cat_reg}: Fictitious data about training cats to dance.
\item \link{cetinkaya_2006}: data from a study by Cetinkaya and Domjan (2006) about quails with sexual fetishes. Seriously.
\item \link{chamorro_premuzic}: Data about what students want (personality wise) from their lecturers.
\item \link{child_aggression}: Fictitious data (based on real research) about predicting aggression in children.
\item \link{coldwell_2006}: Data predicting childhood adjustment from various parenting variables.
\item \link{cosmetic}: Fictitious multilevel data predicting quality of life from cosmetic surgery.
\item \link{daniels_2012}: Data about the effects of sexualised sports images on self-image.
\item \link{dark_lord}: Fictitious data about the subliminal messages in songs.
\item \link{davey_2003}: Data about the effects mood and stop rules on checking behaviour.
\item \link{dog_training}: Data about the training dogs to vocalise when they sniff alien life forms.
\item \link{download}: Fictitious data about the download music festival and being smelly.
\item \link{df_beta}: Fictitious data used to illustrate the DF Beta statistic.
\item \link{eel}: Fictitious data about a randomized control trial to test whether eel therapy is an effective treatment of constipation.
\item \link{elephooty}: Fictitious data about elephants playing football (soccer).
\item \link{escape}: Fictitious data about whether I'm a better songwriter than my school bandmate Malcolm.
\item \link{essay_marks}: Fictitious data about essay marking.
\item \link{exam_anxiety}: Fictitious data about exam performance, anxiety and revision.
\item \link{field_2006}: Data that tests a hypothesis that threat information affects children's avoidance of novel animals.
\item \link{gallup_2003}: Data that tests a hypothesis about why penises have a bell end.
\item \link{gelman_2009}: Data used to critically evaluate the explanations (and claim) that there are more beautiful women than men in the world.
\item \link{glastonbury}: More fictitious data about music festivals and being smelly.
\item \link{goggles}: Fictitious data about whether alcohol affects perception of physical attractiveness.
\item \link{goggles_lighting}: fictitious data about the moderating effect of lighting on the ratings of attractivenesses of faces after different doses of alcohol.
\item \link{grades}: Fictitious data about statistics grades.
\item \link{ice_bucket}: Data about the ice bucket challenge.
\item \link{invisibility_base}: Fictitious data about how much mischief people would get up to if they had an invisibility cloak using a pre-post study design.
\item \link{invisibility_cloak}: Fictitious data about how much mischief people would get up to if they had an invisibility cloak using an independent design.
\item \link{invisibility_rm}: Fictitious data about how much mischief people would get up to if they had an invisibility cloak but using a repeated measures design.
\item \link{hangover}: fictitious data about the efficacy of different drinks as cures for a hangover.
\item \link{hiccups}: Fictitious data on digital rectal stimulation and hiccups.
\item \link{hill_2007}: Data from Hill et al. (2007) testing the effect of different forms of psychoeducation on exercise behaviour.
\item \link{honesty_lab}: Fictitious data about perceptions of honesty.
\item \link{jiminy_cricket}: Fictitious data about whether wishing on a star makes you successful.
\item \link{johns_2012}: Data about whether the colour red is a mating signal to men.
\item \link{lambert_2012}: Data about whether pornography use is related to relationship commitment and infidelity.
\item \link{massar_2012}: Data about whether gossiping has an evolutionary function.
\item \link{mcnulty_2008}: Simulated data to match the results of a study about whether attractiveness is linked to the support given within a relationship.
\item \link{men_dogs}: Fictitious data about whether men exhibit dog-like behaviours (compared to dogs).
\item \link{metal}: Fictitious data about whether listening to metal music makes you angry.
\item \link{metal_health}: Fictitious data about whether listening to heavy metal negatively affects mental health.
\item \link{metallica}: Data about thrash metal band Metallica.
\item \link{miller_2007}: Data from Miller et al. (2007) testing the hidden-estrus theory.
\item \link{mixed_attitude}: Fictitious data about whether different type of imagery in advertising affect ratings of different types of drinks based on the gender identity of the participant.
\item \link{murder}: Fictitious data about the number of murder each month at three street locations (Ruskin Avenue, Acacia Avenue and Rue Morgue).
\item \link{muris_2008}: Data about whether you can train children to interpret ambiguous situations in a particular way.
\item \link{nichols_2004}: Data from the development of the Internet Addiction Scale, IAS (Nichols & Nicki, 2004).
\item \link{notebook}: Fictitious data about whether watching the film the notebook is emotionally arousing.
\item \link{ocd}: Fictitious data about interventions for obsessive compulsive disorder.
\item \link{ong_2011}: Data about social media profile pictures and personality traits.
\item \link{ong_tidy}: Data about social media profile pictures and personality traits.
\item \link{penalty}: Fictitious data about predictors of penalty kick success in soccer (or whatever sport you enjoy).
\item \link{profile_pic}: Fictitious data related to whether the number of friend requests from random people on social media is affected by whether your profile picture depicts you as single or part of a romantic couple.
\item \link{pubs}: Data illustrating the difference between an outlier and an influential case.
\item \link{puppies}: Fictitious data related to whether puppy therapy works.
\item \link{puppy_love}: Fictitious data related to whether puppy therapy works when you adjust for a person's love of puppies.
\item \link{raq}: Fictitious data relating to a fictional questionnaire about R anxiety that is not an actual questionnaire.
\item \link{r_exam}: Fictitious data relating to an R exam at two universities.
\item \link{reality_tv}: Fictitious data relating to whether being on a reality TV show exacerbates personality disorder traits.
\item \link{roaming_cats}: Fictitious data about how far cats roam from their homes.
\item \link{rollercoaster}: Fictitious data about how roller-coaster induced fear affects attractiveness ratings.
\item \link{santas_log}: Fictitious data related to whether the type and quantity of treat consumed on Christmas night affects whether elves successfully deliver presents.
\item \link{self_help}: Fictitious data about whether self-help books improve relationship satisfaction.
\item \link{self_help_dsur}: Fictitious data about whether self-help books improve relationship satisfaction compared to statistics books.
\item \link{sharman_2015}: Data from Sharman & Dingle (2015) about whether listening to metal music increases anger.
\item \link{shopping}: Fictitious data about shopping.
\item \link{sniffer_dogs}: Fictitious data about training sniffer dogs to detect alien space lizards when they try to mask their identity with different scents. See also \link{alien_scents}.
\item \link{social_anxiety}: Fictitious (I think) data about whether social anxiety symptoms are specific to social anxiety.
\item \link{social_media}: Fictitious data about the effects of social media on grammar.
\item \link{soya}: fictitious data about the effects of eating soya on sperm count.
\item \link{speed_date}: Fictitious data related to the extent to which interest in dating someone is affected by their looks, personality or the dating strategy they adopt.
\item \link{stalker}: fictitious data about therapy for stalking.
\item \link{students}: I can't even remember what this data file contains.
\item \link{superhero}: fictitious data about whether wearing different superhero costumes leads to more severe physical injuries.
\item \link{supermodel}: Fictitious data about supermodel salaries.
\item \link{switch}: Fictitious data relating to whether injuries from playing video console games can be mitigated by a warm up.
\item \link{tablets}: Fictitious data about predicting the desirability of computing tablets.
\item \link{tea_15}: Fictitious data based on real data about cognitive functioning and drinking tea.
\item \link{tea_716}: Fictitious data based on real data about cognitive functioning and drinking tea.
\item \link{teaching}: Fictitious data about the success of different methods of teaching.
\item \link{teach_method}: More fictitious data about the success of different methods of teaching.
\item \link{text_messages}: fictitious data about whether use of messaging apps ruins your grammar.
\item \link{tosser}: Fictitious data relating to a fictional questionnaire about The Teaching of Statistics for Scientific Experiments, which is fictional.
\item \link{tuk_2011}: Data about whether needing to urinate helps decision making.
\item \link{tumour}: fictitious data about mobile phone use and brain tumours.
\item \link{tutor_marks}: fictitious data comparing 4 tutors marks of the same essays.
\item \link{van_bourg_2020}: Data from van Bourg et al (2020) relating to whether dogs would release their distressed owners from a box.
\item \link{video_games}: Fictitious data about the relationship between video game use, callous unemotional traits and aggression.
\item \link{williams}: Data relating to the development of a questionnaire to measure organizational ability.
\item \link{xbox}: Fictitious data relating injuries to the type of video console game played and the console it was played on.
\item \link{tuk_2011}: Data about whether needing to urinate helps decision making.
\item \link{zhang_sample}: Data about whether performing a maths test under a different name assists performance.
\item \link{zibarras_2008}: Data from Zibarras, Port, and Woods (2008) relating to the relationship between personality and creativity.
\item \link{zombie_growth}: fictitious data that mimics a randomised control trial over time testing an intervention to transform zombies back to their pre-zombified state.
\item \link{zombie_rehab}: fictitious data that mimics a randomised control trial testing an intervention to transform zombies back to their pre-zombified state in different clinics.
}
}

\section{Smart Alex solutions}{


Solutions for end of chapter tasks are available at \href{https://www.discovr.rocks/solutions/alex/}{www.discovr.rocks/solutions/alex/}.
}

\section{Labcoat Leni solutions}{


Solutions for the Labcoat Leni tasks are available at \href{https://www.discovr.rocks/solutions/leni/}{www.discovr.rocks/solutions/leni/}.
}

\section{Chapter code}{


Although I recommend working through the interactive solutions, each book Chapter has online code and a downloadable R Markdown file available from \href{https://www.discovr.rocks/solutions/code/}{www.discovr.rocks/solutions/leni/}.
}

\section{Colour palettes}{

\subsection{Colour palettes}{

A colour blind-friendly pallette based on \href{https://jfly.uni-koeln.de/color/}{Okabe and Ito}. Also colour themes based around the studio albums of my favourite band \href{https://www.ironmaiden.com}{Iron Maiden}.
If you're wondering why some albums are missing, here's the explanation: X Factor (would basically be 8 shades of grey), Fear of the Dark (terrible album), The Book of Souls (would be 8 shades of black).
The following palettes exist.
\itemize{
\item \link{amolad_pal}: Colour palette (8 colour) based on Iron Maiden's \href{https://www.ironmaiden.com/studio-album/a-matter-of-life-and-death/}{A Matter of Life and Death} album sleeve. In \code{ggplot2} use \link{scale_color_amolad} and \link{scale_fill_amolad}.
\item \link{bnw_pal}: Colour palette (8 colour) based on Iron Maiden's \href{https://www.ironmaiden.com/studio-album/brave-new-world/}{Brave New World} album sleeve. In \code{ggplot2} use \link{scale_color_bnw} and \link{scale_fill_bnw}.
\item \link{dod_pal}: Colour palette (8 colour) based on Iron Maiden's \href{https://www.ironmaiden.com/studio-album/dance-of-death/}{Dance of Death} album sleeve. In \code{ggplot2} use \link{scale_color_dod} and \link{scale_fill_dod}.
\item \link{frontier_pal}: Colour palette (8 colour) based on Iron Maiden's \href{https://www.ironmaiden.com/studio-album/the-final-frontier/}{The Final Frontier} album sleeve. In \code{ggplot2} use \link{scale_color_frontier} and \link{scale_fill_frontier}.
\item \link{im_pal}: Colour palette (8 colour) based on Iron Maiden's \href{https://www.ironmaiden.com/studio-album/iron-maiden/}{eponymous} album sleeve. In \code{ggplot2} use \link{scale_color_im} and \link{scale_fill_im}.
\item \link{killers_pal}: Colour palette (8 colour) based on Iron Maiden's \href{https://www.ironmaiden.com/studio-album/killers/}{Killers} album sleeve. In \code{ggplot2} use \link{scale_color_killers} and \link{scale_fill_killers}.
\item \link{nob_pal}: Colour palette (8 colour) based on Iron Maiden's \href{https://www.ironmaiden.com/studio-album/the-number-of-the-beast/}{The Number of the Beast} album sleeve. In \code{ggplot2} use \link{scale_color_nob} and \link{scale_fill_nob}.
\item \link{okabe_ito_pal}: Colourblind-friendly palette (8 colour) from \href{https://jfly.uni-koeln.de/color/}{Okabe and Ito}. In \code{ggplot2} use \link{scale_color_oi} and \link{scale_fill_oi}.
\item \link{pom_pal}: Colour palette (8 colour) based on Iron Maiden's \href{https://www.ironmaiden.com/studio-album/piece-of-mind/}{Piece of Mind} album sleeve. In \code{ggplot2} use \link{scale_color_pom} and \link{scale_fill_pom}.
\item \link{power_pal}: Colour palette (8 colour) based on Iron Maiden's \href{https://www.ironmaiden.com/studio-album/powerslave/}{Powerslave} album sleeve. In \code{ggplot2} use \link{scale_color_power} and \link{scale_fill_power}.
\item \link{prayer_pal}: Colour palette (8 colour) based on Iron Maiden's \href{https://www.ironmaiden.com/studio-album/no-prayer-for-the-dying/}{No Prayer for the Dying} album sleeve. Use \link{scale_color_prayer} and \link{scale_fill_prayer}.
\item \link{senjutsu_pal}: Colour palette (10 colour) based on the inner gatefold image of Iron Maiden's \href{https://www.ironmaiden.com/studio-album/senjutsu/}{Senjutsu album} album sleeve. In \code{ggplot2} use \link{scale_color_senjutsu} and \link{scale_fill_senjutsu}.
\item \link{sit_pal}: Colour palette (8 colour) based on Iron Maiden's \href{https://www.ironmaiden.com/studio-album/somewhere-in-time/}{Somewhere in Time} album sleeve. In \code{ggplot2} use \link{scale_color_sit} and \link{scale_fill_sit}.
\item \link{ssoass_pal}: Colour palette (8 colour) based on Iron Maiden's \href{https://www.ironmaiden.com/studio-album/seventh-son-of-a-seventh-son/}{Seventh Son of a Seventh Son} album sleeve. In \code{ggplot2} use \link{scale_color_ssoass} and \link{scale_fill_ssoass}.
\item \link{tol_muted_pal}: Palette (9 colour) used in the book from \href{https://sronpersonalpages.nl/~pault/data/colourschemes.pdf}{Paul Tol}. In \code{ggplot2} use \link{scale_color_tol} and \link{scale_fill_tol}.
\item \link{virtual_pal}: Colour palette (8 colour) based on Iron Maiden's \href{https://www.ironmaiden.com/studio-album/virtual-xi/}{Virtual IX} album sleeve. In \code{ggplot2} use \link{scale_color_virtual} and \link{scale_fill_virtual}.
}
}
}

\section{References}{

\itemize{
\item Field, A. P. (2023). \emph{Discovering statistics using R and RStudio} (2nd ed.). London: Sage.
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://www.discovr.rocks}
  \item \url{https://github.com/profandyfield/discovr}
  \item Report bugs at \url{https://github.com/profandyfield/discovr/issues}
}

}
\author{
\strong{Maintainer}: Andy Field \email{andyf@sussex.ac.uk} [copyright holder]

}
