% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discovr_data.R
\docType{data}
\name{davey_2003}
\alias{davey_2003}
\title{Davey et al. (2003) data}
\format{
A tibble with 60 rows and 4 variables.
}
\source{
\href{https://www.discovr.rocks/csv/davey_2003.csv}{www.discovr.rocks/csv/davey_2003.csv}
}
\usage{
davey_2003
}
\description{
A dataset from Field, A. P. (2026). Discovering statistics using R and RStudio (2nd ed.). London: Sage.
}
\details{
Many of us have experienced that feeling after we have left the house of wondering whether we remembered to lock the door,
close the window, or remove the bodies from the fridge in case the police turn up. However,
some people with obsessive compulsive disorder (OCD) check things so excessively that they might, for example,
take hours to leave the house. One theory is that this checking behaviour is caused by the mood you
are in (positive or negative) interacting with the rules you use to decide when to stop a task
(do you continue until you feel like stopping, or until you have done the task as best as you can?).
Davey et al. (2003) tested this hypothesis by asking participants
to think of as many things as they could that they should check before going on holiday (\strong{checks})
after putting them into a negative, positive or neutral mood (\strong{mood}). Within each mood group,
half of the participants were instructed to generate as many items as they could, whereas the
remainder were asked to generate items for as long as they felt like continuing the task (\strong{stop_rule}).
These are the data from that study. The data contains the following variables:
\itemize{
\item \strong{id}: Participant id
\item \strong{mood}: whether a particular was randomly allocated to a negative, positive or neutral mood induction condition.
\item \strong{stop_rule}: whether a particular was randomly allocated to a condition in which they were instructed to undertake a task using an 'as many as can' stop rule or a 'feel like continuing' stop rule.
\item \strong{checks}: number of things participants
}
}
\references{
\itemize{
\item Davey, G. C. L., Startup, H. M., Zara, A., MacDonald, C. B., & Field, A. P. (2003). The perseveration of checking thoughts and mood–as–input hypothesis. \emph{Journal of Behavior Therapy and Experimental Psychiatry}, 34(2), 141–160. \doi{10.1016/S0005-7916(03)00035-1}
}
}
\keyword{datasets}
