% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/litsearchr.functions.R
\name{get_ngrams}
\alias{get_ngrams}
\title{Extract n-grams from text}
\usage{
get_ngrams(
  x,
  n = 2,
  min_freq = 1,
  ngram_quantile = NULL,
  stop_words,
  rm_punctuation = FALSE,
  preserve_chars = c("-", "_"),
  language = "English"
)
}
\arguments{
\item{x}{A character vector from which to extract n-grams.}

\item{n}{Numeric: the minimum number of terms in an n-gram.}

\item{min_freq}{Numeric: the minimum number of times an n-gram must occur to be returned.}

\item{ngram_quantile}{Numeric: what quantile of ngrams should be retained. Defaults to 0.8; i.e. the 80th percentile of ngram frequencies.}

\item{stop_words}{A character vector of stopwords to ignore.}

\item{rm_punctuation}{Logical: should punctuation be removed before selecting ngrams?}

\item{preserve_chars}{A character vector of punctuation marks to be retained if rm_punctuation is TRUE.}

\item{language}{A string indicating the language to use for removing stopwords.}
}
\value{
A character vector of n-grams.
}
\description{
This function extracts n-grams from text.
}
\examples{
get_ngrams("On the Origin of Species By Means of Natural Selection")
}
