% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getHSAM.R
\name{getHSAM}
\alias{getHSAM}
\title{High Spectral Anomaly Mangitude (HSAM)}
\usage{
getHSAM(resid, years, for.year = NULL)
}
\arguments{
\item{resid}{A vector of residual values generated with respect to the baseline signal}

\item{years}{A vector of years corrosponding to the residual values}

\item{for.year}{(optional) Calculate HSAM values only for the given year in this argument.
If argument is omitted, HSAM values for all years are calculated.}
}
\value{
Data frame containing four columns:
\tabular{ll}{
\code{year} \tab First column, represents year \cr
\code{HSAM} \tab Second column, represents HSAM values \cr
\code{index.year} \tab Third column, representing index of HSAM value in that \code{year} \cr
\code{index.all} \tab Fourth column, representing index of HSAM value in the input \code{resid} \cr
}
}
\description{
Compute High Spectral Anomaly Magnitude (HSAM) from the given residual values each year
}
\examples{
# load sample data
data("sycamore")
x = sycamore

# get streamflow object for the sample data
x.streamflow = asStreamflow(x)

# prepare baseline signal 
x.bl = prepareBaseline(x.streamflow)

# HSAM
hsam = getHSAM(x.bl$resid.sig, x.streamflow$data$year)

}
