% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiscSurvEstimation.R
\name{estSurvCens}
\alias{estSurvCens}
\title{Estimated Survival Function of Censoring Process}
\usage{
estSurvCens(dataShort, timeColumn, eventColumns)
}
\arguments{
\item{dataShort}{Data in original short format ("class data.frame").}

\item{timeColumn}{Name of column with discrete time intervals ("character
vector").}

\item{eventColumns}{Names of the event columns of \code{dataShort}("character vector"). In the
competing risks case the event columns have to be in dummy encoding format
("numeric vector").}
}
\value{
Named vector of estimated survival function of the censoring process
for all time points except the last theoretical interval.
}
\description{
Estimates the marginal survival function G(T=t) of the censoring process based on 
a life table estimator. Compatible with single event and competing risks data.
}
\note{
In the censoring survival function the last time interval [a_q, Inf)
has the probability of zero.
}
\examples{


# Load unemployment data
library(Ecdat)
data(UnempDur)

# Select subsample
subUnempDur <- UnempDur [1:100, ]

######################
# Single event example

# Estimate censoring survival function G(t)
estG <- estSurvCens(dataShort = subUnempDur, timeColumn = "spell", 
eventColumns = "censor1")
estG

#########################
# Competing risks example

# Estimate censoring survival function G(t)
estG <- estSurvCens(dataShort = subUnempDur, timeColumn = "spell", 
eventColumns = c("censor1", "censor2", "censor3", "censor4"))
estG


}
\references{
\insertRef{tutzModelDisc}{discSurv}
}
\seealso{
\code{\link{estSurv}}
}
\author{
Thomas Welchowski \email{welchow@imbie.meb.uni-bonn.de}
}
\keyword{survival}
