% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiscSurvEvaluation.R
\name{devResid}
\alias{devResid}
\title{Deviance Residuals}
\usage{
devResid(dataLong, hazards)
}
\arguments{
\item{dataLong}{Original data in long format ("class data.frame").
The correct format can be specified with data preparation, see e. g.
\code{\link{dataLong}}.}

\item{hazards}{Estimated discrete hazards of the data in long format("numeric vector"). Discrete
discrete hazards are probabilities and therefore restricted to the interval [0,
1].}
}
\value{
\itemize{ \item{Output} List with objects: \itemize{ \item{DevResid}
Square root of deviance residuals as numeric vector.  } \item{Input} A list
of given argument input values (saved for reference) }
}
\description{
Computes the root of the deviance residuals for evaluation of performance in
discrete survival analysis.
}
\examples{

library(survival)

# Transform data to long format
heart[, "stop"] <- ceiling(heart[, "stop"])
set.seed(0)
Indizes <- sample(unique(heart$id), 25)
randSample <- heart[unlist(sapply(1:length(Indizes), 
function(x) which(heart$id == Indizes[x]))),]
heartLong <- dataLongTimeDep(dataSemiLong = randSample, 
timeColumn = "stop", eventColumn = "event", idColumn = "id", timeAsFactor = FALSE)

# Fit a generalized, additive model and predict discrete hazards on data in long format
library(mgcv)
gamFit <- gam(y ~ timeInt + surgery + transplant + s(age), data = heartLong, family = "binomial")
hazPreds <- predict(gamFit, type = "response")

# Calculate the deviance residuals
devResiduals <- devResid (dataLong = heartLong, hazards = hazPreds)$Output$DevResid

# Compare with estimated normal distribution
plot(density(devResiduals), 
main = "Empirical density vs estimated normal distribution", 
las = 1, ylim = c(0, 0.5))
tempFunc <- function (x) dnorm(x, mean = mean(devResiduals), sd = sd(devResiduals))
curve(tempFunc, xlim = c(-10, 10), add = TRUE, col = "red")
# The empirical density seems like a mixture distribution, 
# but is not too far off in with values greater than 3 and less than 1

}
\references{
\insertRef{tutzModelDisc}{discSurv} \cr\cr
\insertRef{tutzRegCat}{discSurv}
}
\seealso{
\code{\link{adjDevResid}}, \code{\link{predErrCurve}}
}
\author{
Thomas Welchowski \email{welchow@imbie.meb.uni-bonn.de}
}
\keyword{survival}
