% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gini.wtd.R
\name{gini.wtd}
\alias{gini.wtd}
\title{Gini coefficient}
\source{
Handcock, M. (2016), Relative Distribution Methods. Version 1.6-6. Project home page
at http://www.stat.ucla.edu/~handcock/RelDist.
}
\usage{
gini.wtd(x, weights = NULL)
}
\arguments{
\item{x}{a numeric vector containing at least non-negative elements.}

\item{weights}{an optional vector of weights of x to be used in the computation of the Gini
coefficient. Should be NULL or a numeric vector.}
}
\value{
The value of the Gini coefficient.
}
\description{
Returns the (optional weighted) Gini coefficient for a vector.
}
\details{
The Gini coefficient is a measure of inequality among values of a distribution. The most
used single measure for income inequality. The coefficient can theoretically range between 0 and
1, with 1 being the highest possible inequality (for instance: 1 person in a society has all
income; the others none). But coefficients that are negative or greater than 1 are also possible
because of negative values in the distribution. Compared to other measures of inequality,
the Gini coefficient is especially sensitive for changes in the middle of the distribution.

Extension of the gini function in reldist package in order to handle missings.
}
\examples{
#calculate Gini coefficient using Mexican Income data set
data(mex_inc_2008)

#unweighted Gini coefficient:
gini.wtd(mex_inc_2008$income)

#weighted Gini coefficient:
gini.wtd(x=mex_inc_2008$income, weights=mex_inc_2008$factor)

}
\references{
Haughton, J. and S. Khandker. (2009) \emph{Handbook on poverty and inequality},
Washington, DC: World Bank.

Cowell F. (2000) Measurement of Inequality. In Atkinson A. and Bourguignon F. (eds.) \emph{
Handbook of Income Distribution}. Amsterdam: Elsevier, p. 87-166.
}
