% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsQueryBuild.R
\name{dsQueryBuild}
\alias{dsQueryBuild}
\title{Generate a DSL query from a set of parameters
It generates a valid query, written following the Dimensions Search Language (DSL), from a set of search parameters.}
\usage{
dsQueryBuild(
  item = "publications",
  words = "bibliometric*",
  words_boolean_op = "OR",
  full.search = FALSE,
  type = "article",
  categories = "",
  output_fields = "all",
  start_year = NULL,
  end_year = NULL
)
}
\arguments{
\item{item}{is a character. It indicates the type of document to search. 
The argument can be equal to \code{item = ("publications", "grants", "patents", "clinical_trials", "policy_documents")}. 
Default value is \code{item = "publications"}.}

\item{words}{is a character vector. It contains the search terms.}

\item{words_boolean_op}{is character. It indicates which boolean operator have to be used to link words. It can be c("OR","AND"). Default is "OR".}

\item{full.search}{is logical. If TRUE, full-text search finds all instances of a term (keyword) in a document, or group of documents. If False, the search finds all instances in titles and abstracts only.}

\item{type}{is a character. It indicates the document type to include in the search. Default is \code{type = "article"}.}

\item{categories}{is a character vector. It indicates the research categories to include in the search. If empty \code{categories = ""}, all categories will be included in the search.}

\item{output_fields}{is a character vector. It contains a list of fields which have to exported. Default is "all".}

\item{start_year}{is integer. It indicate the starting publication year of the search timespan.}

\item{end_year}{is integer. It indicate the ending publication year of the search timespan.}
}
\value{
a character containing the query in DSL format.

For more extensive information about Dimensions Search Language (DSL), please visit: \href{https://docs.dimensions.ai/dsl/}{https://docs.dimensions.ai/dsl/}

To obtain a free access to Dimenions API fro no commercial use, please visit: \href{https://ds.digital-science.com/NoCostAgreement}{https://ds.digital-science.com/NoCostAgreement}
}
\description{
Generate a DSL query from a set of parameters
It generates a valid query, written following the Dimensions Search Language (DSL), from a set of search parameters.
}
\examples{

\dontrun{
query <- dsQueryBuild(item = "publications", words = "bibliometric*", 
                       type = "article", categories = "management", 
                       start_year=1980,end_year = 2020)
}

}
\seealso{
\code{\link{dsApiRequest}}

\code{\link{dsAuth}}

\code{\link{dsApi2df}}
}
