% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devRate_qualityFits.R
\name{devRateQlBio}
\alias{devRateQlBio}
\title{Biological likelihood of nls fits}
\usage{
devRateQlBio(nlsDR, propThresh = 0.01, eq, interval = c(0, 50))
}
\arguments{
\item{nlsDR}{A list of nls objects.}

\item{propThresh}{The proportion of maximal development rate used as a
threshold for estimating XTmin and XTmax for asymptotic equations
(default value is 0.01)}

\item{eq}{A list of equations used for nls fitting.}

\item{interval}{A vector containing the lower and upper boundaries of the
interval of temperatures in which metrics are searched.}
}
\value{
An object of class \code{data.frame} with development metrics (CTmin,
  Ctmax, Topt, XTmin, XTmax) in columns and nls objects in rows.
}
\description{
Return a table of 5 metrics of development (CTmin, CTmax, Topt, XTmin, XTmax)
}
\details{
NULL is returned when nlsDR or eq are not a list.
}
\examples{
myDf <- data.frame(temp = seq(from = 0, to = 50, by = 10),
 rT = c(0.001, 0.008, 0.02, 0.03, 0.018, 0.004))
myNLS <- list(
 devRateModel(
   eq = janisch_32,
   df = myDf,
   startValues = list(aa = 0.2, bb = 0.1, Dmin = 10, Topt = 30),
   algo = "LM"),
 devRateModel(
   eq = kontodimas_04,
   df = myDf,
   startValues = list(aa = 1, Tmin = 7, Tmax = 40),
   algo = "LM"),
 devRateModel(
   eq = poly2,
   df = myDf,
   startValues = list(a0 = 1, a1 = 1, a2 = 1),
   algo = "LM"))
devRateQlBio(
  nlsDR = myNLS,
  eq = list(janisch_32, kontodimas_04, poly2),
  propThresh = 0.1)
}
