% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkFuncs.R
\name{checkIntVec}
\alias{checkIntVec}
\title{Checking if all elements of a list are all integer vectors}
\usage{
checkIntVec(listInt, namesListElements = NULL)
}
\arguments{
\item{listInt}{A list of the vectors of which one wishes to check if their data type is integer}

\item{namesListElements}{Character vector containing the names of the variables of which the data type is checked. Optional parameter, with as default value NULL. This argument should be used when the variable of which the data type is checked is not an object that was provided as an argument to the function, or when the list elements of the first argument do not have a name attached to it.}
}
\value{
No value is returned if all vectors have the integer data type. If not, an error message is thrown for each element of the list that does not pertain to the integer data type.
}
\description{
Checking if all elements of a list are all integer vectors
}
\examples{
arg1 <- 1L
checkIntVec(list(arg1))

\donttest{checkIntVec(list(1L, TRUE, 2L))

arg2 <- 'R'
checkIntVec(list(arg2))
checkIntVec(list(arg2, TRUE, 2))}
}
