% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crtunmatch.R
\name{crt.unmatch}
\alias{crt.unmatch}
\title{Cluster number determination for cluster randomized trails (CRT) unmatched case}
\usage{
crt.unmatch(type, m, u1, u2, sigma1.B, sigma1.W, sigma2.B, sigma2.W,
            rho1, rho2, alpha, beta)
}
\arguments{
\item{type}{There are three different types of comparison i.e. type = c("M", "P", "IR"),
"M" stands for comparison of means,
"P" stands for comparison of proportions and
"IR" stands for comparison of incidence rates}

\item{m}{A common cluster size}

\item{u1}{Mean(for M)/proportion(for P)/incidence rate(for IR) of group-1}

\item{u2}{Mean(for M)/proportion(for P)/incidence rate(for IR) of group-2}

\item{sigma1.B}{Between-cluster standard deviation of group-1}

\item{sigma1.W}{Within-cluster standard deviation of group-1}

\item{sigma2.B}{Between-cluster standard deviation of group-2}

\item{sigma2.W}{Within-cluster standard deviation of group-2}

\item{rho1}{Intra-cluster correlation coefficient(ICC) of group-1}

\item{rho2}{Intra-cluster correlation coefficient(ICC) of group-2}

\item{alpha}{Level of significance}

\item{beta}{The probability of type-II error}
}
\value{
crt.unmatch returns a value indicating the number of clusters needed per group.
}
\description{
Determination of number of clusters per group for unmatched cluster randomized trails
}
\details{
Instead of independent individuals, the unit of randomization is a group of subjects in a cluster
randomized trial(s) or group randomized trial(s). CRTs are generally more complex and the investigators
consider the selection of the unit of randomization and the unit of inference, matching or stratification
to improve treatment balance across clusters. It is also well known that CRTs need more subjects than
individually randomized trials to be adequately powered.

Under unmatched case, no pair of matching is used to control the balance. The simple randomization
technique is generally used.
}
\examples{
# (a) Comparison of means:

# This is a cluster randomized trials for unmatched cases. The type = "M", indicates the
# comparison of means of two groups  taking a common cluster size m = 20. The mean value
# of group-1 and group-2 is u1 = 0.5 and u2 = 0.3 respectively. For group-1, the between
# -cluster standard deviation is sigma1.B = 0.3 and within-cluster standard deviation is
# sigma1.W = 0.3. Similarly, for group-2 those values are sigma2.B=0.3 and sigma2.W=0.3.
# The intra-cluster correlation coefficient (ICC) of group - 1 is rho1 = 0.2 and that of
# group - 2 is rho2 = 0.2. The level of significance is alpha = 0.05 and the probability
# of type-II error is beta = 0.20.


crt.unmatch(type = "M", m = 20, u1 = 0.5, u2 = 0.3, sigma1.B = 0.3, sigma1.W = 0.3,
            sigma2.B = 0.3, sigma2.W = 0.3, rho1 = 0.2, rho2 = 0.2,
            alpha = 0.05, beta = 0.20)


# (b) Comparison of proportions:

# This is a cluster randomized trials for unmatched cases. The type = "P", indicates the
# comparison of proportions of two groups taking a common cluster size m = 20. The prop-
# ortion of group-1 andgroup-2 is u1 = 0.5 and u2 = 0.3 respectively. For group - 1, the
# between-cluster standard deviation is sigma1.B = 0.3 and within-cluster standard devi-
# ation is sigma1.W = 0.3. Similarly, for group-2 the standard deviations are sigma2.B =
# 0.3 and sigma2.W = 0.3. The intra-cluster correlation coefficient(ICC) of group - 1 is
# rho1 = 0.2 and that of group-2 is rho2 = 0.2. The level of significance is alpha =0.05
# and the probability of type-II error is beta = 0.20.


crt.unmatch(type = "P", m = 20, u1 = 0.5, u2 = 0.3, sigma1.B = 0.3, sigma1.W = 0.3,
            sigma2.B = 0.3, sigma2.W = 0.3, rho1 = 0.2, rho2 = 0.2,
            alpha = 0.05, beta = 0.20)


# (c) Comparison of incidence rates:

# This is a cluster randomized trials for unmatched cases. The type = "IR" indicates the
# comparison of incidence rates of two groups taking a total of m = 20 person-years. The
# incidence rate of group-1 and group-2 is u1 = 0.5 and u2 = 0.3 respectively. For group
# -1, the between-cluster standard deviation is sigma1.B = 0.3 and within-cluster stand-
# ard deviation is sigma1.W = 0.3. Similarly, for  group-2  the  standard deviations are
# sigma2.B = 0.3 and sigma2.W = 0.3. The  intra-cluster correlation coefficient (ICC) of
# group-1 is rho1 = 0.2 and  that of group-2 is rho2 = 0.2. The level of significance is
# alpha = 0.05 and the probability of type-II error is beta = 0.20.


crt.unmatch(type = "IR", m = 20, u1 = 0.5, u2 = 0.3, sigma1.B = 0.3, sigma1.W = 0.3,
            sigma2.B = 0.3, sigma2.W = 0.3, rho1 = 0.2, rho2 = 0.2,
            alpha = 0.05, beta = 0.20)
}
\seealso{
ABdesign crt.match expsize phsize precsize prsize crsize
}
\author{
Atanu Bhattacharjee, Rajashree Dey ,Soutik Halder and Akash Pawar
}
