% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_plate}
\alias{plot_plate}
\title{Plot plate layouts}
\usage{
plot_plate(
  .tbl,
  plate = plate,
  row = row,
  column = column,
  .color,
  .alpha = NULL,
  .pattern = NULL,
  title = paste("Layout by", rlang::as_name(rlang::enquo(plate))),
  add_excluded = FALSE,
  rename_empty = FALSE
)
}
\arguments{
\item{.tbl}{a \code{\link[tibble:tibble]{tibble}} (or \code{data.frame}) with the samples assigned to locations.
Alternatively a \link[=BatchContainer]{BatchContainter} with samples can be supplied here.}

\item{plate}{optional dimension variable used for the plate ids}

\item{row}{the dimension variable used for the row ids}

\item{column}{the dimension variable used for the column ids}

\item{.color}{the continuous or discrete variable to color by}

\item{.alpha}{a continuous variable encoding transparency}

\item{.pattern}{a discrete variable encoding tile pattern (needs ggpattern)}

\item{title}{string for the plot title}

\item{add_excluded}{flag to add excluded wells (in bc$exclude) to the plot.
A BatchContainer must be provided for this.}

\item{rename_empty}{whether NA entries in sample table should be renamed to 'empty`.}
}
\value{
the ggplot object
}
\description{
Plot plate layouts
}
\examples{
nPlate <- 3
nColumn <- 4
nRow <- 6

treatments <- c("CTRL", "TRT1", "TRT2")
timepoints <- c(1, 2, 3)


bc <- BatchContainer$new(
  dimensions = list(
    plate = nPlate,
    column = list(values = letters[1:nColumn]),
    row = nRow
  )
)

sample_sheet <- tibble::tibble(
  sampleID = 1:(nPlate * nColumn * nRow),
  Treatment = rep(treatments, each = floor(nPlate * nColumn * nRow) / length(treatments)),
  Timepoint = rep(timepoints, floor(nPlate * nColumn * nRow) / length(treatments))
)

# assign samples from the sample sheet
bc <- assign_random(bc, samples = sample_sheet)

plot_plate(bc$get_samples(),
  plate = plate, column = column, row = row,
  .color = Treatment, .alpha = Timepoint
)

\donttest{
plot_plate(bc$get_samples(),
  plate = plate, column = column, row = row,
  .color = Treatment, .pattern = Timepoint
)
}
}
\author{
siebourj
}
