% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assignment.R
\name{assign_random}
\alias{assign_random}
\title{Assignment function which distributes samples randomly.}
\usage{
assign_random(batch_container, samples = NULL)
}
\arguments{
\item{batch_container}{Instance of BatchContainer class}

\item{samples}{data.frame with samples.}
}
\value{
Returns a new \code{BatchContainer}.
}
\description{
Assignment function which distributes samples randomly.
}
\examples{
samples <- data.frame(sampId = 1:3, sampName = letters[1:3])
samples

bc <- BatchContainer$new(dimensions = c("row" = 3, "column" = 2))
bc

set.seed(42)
# assigns samples randomly
bc <- assign_random(bc, samples)
bc$get_samples()

# assigns samples in order
bc <- assign_in_order(bc)
bc$get_samples()
}
