% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-decomp.R
\name{trend,decomp-method}
\alias{trend,decomp-method}
\alias{season,decomp-method}
\alias{fitted,decomp-method}
\alias{residuals,decomp-method}
\alias{deseasonalize,decomp-method}
\alias{detrend,decomp-method}
\title{Obtain Individual Components of a Decomposed Time Series}
\usage{
\S4method{trend}{decomp}(object, ...)

\S4method{season}{decomp}(object, ...)

\S4method{fitted}{decomp}(object, ...)

\S4method{residuals}{decomp}(object, ...)

\S4method{deseasonalize}{decomp}(object, ...)

\S4method{detrend}{decomp}(object, ...)
}
\arguments{
\item{object}{the estimation / decomposition object, for example 
of class \code{"deseats"}.}

\item{...}{without further use; implemented for compatibility only.}
}
\value{
These methods return time series objects of class \code{"ts"} that represent
the corresponding estimated component in the time series originally used in
the estimation process.
}
\description{
The provided methods work for decomposition objects created 
within this package. They allow the user to retrieve individual
components among the estimated ones.
}
\details{
Apply these functions directly to an estimation object, i.e. 
the result of a decomposition of a seasonal time series, in order 
to retrieve individual estimated components.
}
\examples{
\donttest{
Xt <- log(EXPENDITURES)
smoothing_options <- set_options(order_poly = 3)
est <- deseats(Xt, smoothing_options = smoothing_options)
trend_e <- trend(est)           # Trend estimates
season_e <- season(est)         # Seasonality estimates
trend_season_e <- fitted(est)   # Trend + seasonality estimates
resid_e <- residuals(est)       # Residuals (observ. - trend - seasonality)
ts_adj <- deseasonalize(est)    # Seasonally adjusted series
ts_notrend <- detrend(est)      # Detrended series
}

}
