% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dep_calc_index.R
\name{dep_calc_index}
\alias{dep_calc_index}
\title{Perform Deprivation Calculations}
\usage{
dep_calc_index(.data, geography, index, year, survey = "acs5",
    return_percentiles = FALSE, keep_subscales = FALSE, keep_components = FALSE,
    output = "wide")
}
\arguments{
\item{.data}{A data frame, tibble, or \code{sf} object that contains all
of the columns needed to calculate your selected deprivation measure(s).
See Details below.}

\item{geography}{A character scalar; one of \code{"county"}, \code{"zcta3"},
\code{"zcta5"}, or \code{"tract"}}

\item{index}{A character scalar or vector listing deprivation measures
to return. These include the area deprivation index (\code{"adi"}),
the gini coefficient (\code{"gini"}), two versions of the neighborhood
deprivation index by Messer (\code{"ndi_m"}) and Powell and Wiley
(\code{"ndi_pw"}), and four versions of the social vulnerability
index (\code{"svi10"}, \code{"svi14"}, \code{"svi20"}, and \code{"svi20s"}).
See Details.}

\item{year}{A numeric scalar between 2010 and 2022.}

\item{survey}{A character scalar representing the Census product. It can
be any American Community Survey product (either \code{"acs1"},
\code{"acs3"}, or \code{"acs5"}). Note that \code{"acs3"} was
discontinued after 2013.}

\item{return_percentiles}{A logical scalar; if \code{TRUE}, scales
(and their subscales) will be returned as percentiles instead of in
raw scores. If \code{FALSE} (default), raw scores will be returned. Note
that SVI is returned as a percentile regardless of what
\code{return_percentiles} is set to.}

\item{keep_subscales}{A logical scalar; if \code{FALSE} (default), only the
full ADI and/or SVI scores (depending on what is passed to the \code{index}
argument) will be returned. If \code{TRUE} and \code{"svi"} is listed for
the \code{index} argument, the four SVI "themes" (see Details) will be
returned along with the full SVI score. Similarly, if \code{"adi"} is
listed for the \code{index} argument, the three ADI subscales (see Details)
will be returned.}

\item{keep_components}{A logical scalar; if \code{FALSE} (default), none of
the components used to calculate the deprivation measures will be returned.
If \code{TRUE}, all of the demographic variables used to calculate ADI
and/or SVI will be returned.}

\item{output}{A character scalar; if \code{"wide"} (default), a tibble
will be returned with row per jurisdiction where individual measures of
deprivation stored in columns. If \code{"tidy"}, a tibble will be returned
with one row for each combination of jurisdiction and deprivation measure.}
}
\value{
A tibble object containing the requested deprivation measures.
}
\description{
Calculates various measures of deprivation on data you have.
    Data cannot be automatically downloaded with this option, and the
    output options are more limited. See Details under \code{dep_get_index} for
    more information. For information about structuring your data prior to
    using this function, see Details below.
}
\details{
Input data must be "wide" formatted and should have the following columns:
    \describe{
      \item{\code{"GEOID"}}{The appropriately formatted GEOID values for the
        geography given in the function. This is required.}
      \item{\code{"YEAR"}}{The year that corresponds to the demographic data.
        For five-year ACS data, this should correspond to the final year in
        the period (e.x. 2021 for the 2017-2021 ACS). This is required only
        if deprivation scores are being generated for more than one year.}
      \item{Demographic measures}{All of the necessary columns required for
        the deprivation scores and years given (since the input measures vary
        between scores and over time for individual scores.)}
     }
}
\examples{
## load sample data
ndi_m <- dep_sample_data(index = "ndi_m")

## calculate NDI with sample data
ndi_m <- dep_calc_index(ndi_m, geography = "county", index = "ndi_m", year = 2022,
    return_percentiles = TRUE)

}
