% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permute_dri.R
\name{permute_dri}
\alias{permute_dri}
\title{Permute DRI}
\usage{
permute_dri(data, iterations = 10000, verbose = FALSE, summary = TRUE)
}
\arguments{
\item{data}{raw DRI survey dataframe}

\item{iterations}{number permutations to generate}

\item{verbose}{a logical flag to print time of permutation}

\item{summary}{a logical indicating whether to return the raw data or summary
of test results; raw data is optimal for plotting permutation results}
}
\value{
dataframe with permutation test results, raw or summarized.
Summarized results include the number of participants, \code{n}, the observed DRI,
\code{obs_dri}, the number of permutations conducted, \code{n_perm}, the mean
permutation DRI, \code{mean_perm_dri}, and the frequency which the permutation DRI
is greater or equal to the observed DRI, \code{p}
}
\description{
\code{permute_dri} tests whether the links between considerations and policy
preferences are consistent or likely due to chance
}
\examples{

# get pre-deliberation (stage_id == 1) data from Zukunft case
data <- human_data[human_data$stage_id == 1 & human_data$case == "Zukunft", ]

# permute DRI 100 times
permute_dri(data, iterations = 100)

}
