% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{fgdc_names}
\alias{fgdc_names}
\title{Pattern numbers and names for patterns from the FGDC Digital Cartographic
Standard for Geologic Map Symbolization}
\format{
A data frame with 117 rows and 2 variables:
\describe{
\item{code}{the pattern number according to the FGDC standard}
\item{name}{the verbatim name for the pattern according to the FGDC standard}
}
}
\source{
\url{https://ngmdb.usgs.gov/fgdc_gds/geolsymstd/fgdc-geolsym-patternchart.pdf}
via \url{https://github.com/davenquinn/geologic-patterns/}
}
\usage{
fgdc_names
}
\description{
A dataset containing the FGDC pattern numbers and verbatim names from the
\href{https://ngmdb.usgs.gov/fgdc_gds/geolsymstd.php}{FGDC Digital Cartographic Standard for Geologic Map Symbolization} by the \href{https://www.usgs.gov/}{U.S. Geological Survey} and the \href{https://ngmdb.usgs.gov/fgdc_gds/index.php}{Geologic Data Subcommittee (GDS)} of the \href{https://www.fgdc.gov/}{Federal Geographic Data Committee (FGDC)}. Only patterns with names are
included (i.e., patterns 601-733).
}
\details{
These pattern numbers and names were originally extracted by Daven Quinn and
are hosted on \href{https://github.com/davenquinn/geologic-patterns/}{GitHub}.
}
\seealso{
FGDC patterns:
\code{\link{fgdc_dict}()},
\code{\link{geo_pattern}()},
\code{\link{grid.pattern_geo}()},
\code{\link{scale_fill_geopattern}()}
}
\concept{patterns}
\keyword{datasets}
