% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/extract_diversification_data_melted_df_for_focal_time.R
\name{extract_diversification_data_melted_df_for_focal_time}
\alias{extract_diversification_data_melted_df_for_focal_time}
\title{Extract diversification data from a BAMM_object}
\usage{
extract_diversification_data_melted_df_for_focal_time(
  BAMM_object,
  verbose = TRUE
)
}
\arguments{
\item{BAMM_object}{Object of class \code{"bammdata"}, typically generated with
\code{\link[=update_rates_and_regimes_for_focal_time]{update_rates_and_regimes_for_focal_time()}},
that contains a phylogenetic tree and associated diversification rate mapping
across selected posterior samples.}

\item{verbose}{Logical. Should progression be displayed? A message will be printed for every batch of
100 BAMM posterior samples extracted. Default is \code{TRUE}.}
}
\value{
Returns a data.frame with six columns.
\itemize{
\item \verb{$focal_time} Integer. The time, in terms of time distance from the present, at which the trait data were extracted. Should be equal for all rows
as a unique BAMM_object updated for a unique \code{focal_time} is being extracted.
\item \verb{$BAMM_sample_ID} Integer. ID of the posterior samples from which the diversification data are extracted.
\item \verb{$tip_ID} Character string. Tip labels of the branches cut-off at \code{focal_time}.
\itemize{
\item If \code{keep_tip_labels = TRUE} was used in \code{\link[=update_rates_and_regimes_for_focal_time]{update_rates_and_regimes_for_focal_time()}},
cut-off branches with a single descendant tip retain their initial \code{tip.label}.
\item If \code{keep_tip_labels = FALSE} was used in \code{\link[=update_rates_and_regimes_for_focal_time]{update_rates_and_regimes_for_focal_time()}},
all cut-off branches are labeled using their tipward node ID.
}
\item \verb{$regime_ID} Integer. The regime ID on tips at \code{focal_time}. IDs are integer. The root process equals "1", then they are incremented from oldest to youngest.
Regime IDs are independent across posterior samples.
\item \verb{$rate_type} Character string. Type of rates: "lambda" for speciation rates, "mu" for extinction rates,
and "net_diversification" for net diversification rates (lambda - mu).
\item \verb{$rates} Numerical. Rates in \[number of events / branch / evolutionary time\].
}
}
\description{
Extracts regimes ID and tip rates from a \code{BAMM_object} that have been
updated to provide diversification data for a specific time in the past (i.e. the \code{focal_time}).
Use \code{\link[=update_rates_and_regimes_for_focal_time]{update_rates_and_regimes_for_focal_time()}} to obtain
a \code{BAMM_object} updated for a given \code{focal_time}.
}
\examples{

if (deepSTRAPP::is_dev_version())
{
 # Load the BAMM_object summarizing 1000 posterior samples of BAMM updated for a focal_time of 10 My
 data(Ponerinae_BAMM_object_10My)
 ## This dataset is only available in development versions installed from GitHub.
 # It is not available in CRAN versions.
 # Use remotes::install_github(repo = "MaelDore/deepSTRAPP") to get the latest development version.

 \donttest{ # (May take several minutes to run)
 # Extract diversification data
 diversification_data_df <- extract_diversification_data_melted_df_for_focal_time(
     BAMM_object = Ponerinae_BAMM_object_10My,
     verbose = TRUE)
 # Print output
 head(diversification_data_df) }
}

}
\author{
Maël Doré
}
