% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_disease.R
\name{plot_disease}
\alias{plot_disease}
\title{Title plot_disease}
\usage{
plot_disease(x, suffixes, nDx, line = TRUE)
}
\arguments{
\item{x}{A data frame containing \code{decomp_disease()} output.}

\item{suffixes}{A character vector of disease suffixes to match (e.g., \code{c("CD", "NCD", "Injuries")}). Essentially the same as \code{diseases} argument in \code{decomp_disease()}.}

\item{nDx}{Column name for contribution of all-cause mortality differences in groups 1 and 2 in age groups x to x + n.}

\item{line}{Logical for additional line geom showing total effect. TRUE by default.}
}
\value{
A \code{ggplot} object showing disease breakdown values
}
\description{
Visualize disease-related deltas from a data frame.
It pivots columns starting with \code{"delta"} and ending with user-specified suffixes
(e.g., \code{c("CD", "NCD", "Injuries")}) into a long format and creates a formatted stacked bar plot.
}
\details{
Plot disease decomposition breakdown
}
\examples{

disease_data <- decomp_disease(india_china_males_1990,
  breakdown = "proportion", age_col = "Age", diseases = c("CD", "NCD", "Injuries"),
  group_1 = "India", group_1_m = "India_nmx", group_2 = "China",
  group_2_m = "China_nmx", nDx = "nDx"
)

plot_disease(disease_data, c("delta_CD", "delta_NCD", "delta_Injuries"), "nDx", line = FALSE)
plot_disease(disease_data, c("delta_CD", "delta_NCD", "delta_Injuries"), "nDx", line = TRUE)

}
