% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transactions.R
\name{transactions}
\alias{transactions}
\alias{deb_account}
\alias{deb_account_summary}
\alias{deb_credit}
\alias{deb_debit}
\alias{deb_current}
\alias{deb_open}
\alias{deb_balance}
\title{Analysis of double-entry bookkeeping}
\usage{
deb_account(
  df,
  account_id,
  credit = credit,
  debit = debit,
  lsd = lsd,
  na.rm = FALSE
)

deb_account_summary(
  df,
  credit = credit,
  debit = debit,
  lsd = lsd,
  na.rm = FALSE
)

deb_credit(df, credit = credit, debit = debit, lsd = lsd, na.rm = FALSE)

deb_debit(df, credit = credit, debit = debit, lsd = lsd, na.rm = FALSE)

deb_current(df, credit = credit, debit = debit, lsd = lsd, na.rm = FALSE)

deb_open(df, credit = credit, debit = debit, lsd = lsd, na.rm = FALSE)

deb_balance(df, credit = credit, debit = debit, lsd = lsd, na.rm = FALSE)
}
\arguments{
\item{df}{A data frame or tibble with at least credit, debit, and lsd
columns.}

\item{account_id}{The id of the account to be used to calculate the
credit, debit, and current values.}

\item{credit}{Credit column: Unquoted name of the credit column,
representing the accounts that discharge the transactional values or
from which the values derive. Default is \code{credit}.}

\item{debit}{Debit column: Unquoted name of the debit column,
representing the accounts that receive the transactional values.
Default is \code{debit}.}

\item{lsd}{Value column: Unquoted name of a column of class \code{deb_lsd},
\code{deb_decimal}, or \code{deb_tetra}. Default is \code{lsd}.}

\item{na.rm}{Logical. Should missing values (including \code{NaN}) be removed?}
}
\value{
Transaction functions return a data frame or tibble with columns for the
accounts in \code{df} and credit, debit, and/or current values in the same type
and \code{bases} as \code{lsd}:
\itemize{
\item \code{deb_account()}: a data frame with three rows showing the credit, debit,
and current value of the given account.
\item \code{deb_account_summary()} a data frame with one row for each account in
\code{df} and credit, debit, and current value columns.
\item \code{deb_credit()}: a data frame with one row for each account with the total
credit of the accounts.
\item \code{deb_debit()}: a data frame with one row for each account with the total
debit of the accounts.
\item \code{deb_current()}: a data frame with one row for each account with the
current value of the accounts.
\item \code{deb_open()}: a data frame with one row for each account whose current
value is not \code{0}. If all accounts are equal to zero, a data frame with
zero rows will be returned.
\item \code{deb_balance()}: a data frame with two rows showing the credit and debit
remaining in \code{df}.
}
}
\description{
Family of seven related functions to analyze transactions data frames
that have credit, debit, and tetrapartite (lsd) or tetrapartite (lsdf)
columns, mimicking an account book.
\itemize{
\item \code{deb_account()} credit, debit, and current value of a single account.
\item \code{deb_account_summary()} credit, debit, and current value of all accounts.
\item \code{deb_credit()} total credit of each account.
\item \code{deb_debit()} total debit of each account.
\item \code{deb_current()} current value of each account (credit - debit).
\item \code{deb_open()} current value of each account that has a positive or
negative value.
\item \code{deb_balance()} positive and negative value remaining in a transactions
data frame.
}
}
\section{Transactions data frames:}{
Transactions data frames have the structure of an account book. They
should have a similar arrangement to \code{dafforne_transactions}. Each row is
a transaction in the book. \code{credit} and \code{debit} columns contain the
account ids associated with discharging account (credit) and the receiving
account (debit). The \code{lsd} column represents the tripartite or
tetrapartite value of each transaction. Like \code{dafforne_transactions},
transactions data frames can have additional columns with attributes for
each transaction such as id or date among others.
}

\examples{
# Examples use dafforne_transactions data,
# which have default column names.
# See dafforne_accounts for account names.

# Credit, debit, and current value of cash account
deb_account(dafforne_transactions, account_id = 1,
            credit = credit, debit = debit,
            lsd = lsd)

# Credit, debit, and current value of profit and loss account
deb_account(dafforne_transactions, account_id = 23)

# Summary of all accounts in Dafforne's ledger
deb_account_summary(dafforne_transactions)

# Credit of accounts in Dafforne's ledger
deb_credit(dafforne_transactions)

# Debit of accounts in Dafforne's ledger
deb_debit(dafforne_transactions)

# Current value of accounts in Dafforne's ledger
current <- deb_current(dafforne_transactions)
current

# Current value of open account in Dafforne's ledger
open <- deb_open(dafforne_transactions)
open

# Compare the amount of rows in returned values of
# deb_current() vs deb_open()
nrow(current)
nrow(open)

# Credit and debit remaining on Dafforne's ledger
deb_balance(dafforne_transactions)

}
