% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Scale_within.R
\name{Scale_within}
\alias{Scale_within}
\title{Center the data according to model}
\usage{
Scale_within(userdata, model = NA, center = FALSE, scale = FALSE)
}
\arguments{
\item{userdata}{users' data}

\item{model}{a string specifying the model to be used. The "=~" operator is used to define variables, with the name of the variable user defined on the left and the name of the variable in the data on the right. The '~' operator specifies a differential equation, with the dependent variable on the left and the independent variables on the right. See also ‘Details’.}

\item{center}{TRUE or FALSE}

\item{scale}{TRUE or FALSE}
}
\value{
dataframe
}
\description{
Center the data according to model
}
\examples{
#eg1.
data('example3')
multi_model <- '
  X =~ current
  time =~ myTime
  X(2) ~ X(1) + X + (1 + X(1) + X | year)
  '
scale_mydata <- Scale_within(example3[(example3["year"] >= 2015)&(example3["year"] <= 2018),]
,multi_model
,center=TRUE)
}
