% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glass_fill.R
\name{glass_fill}
\alias{glass_fill}
\title{Visualize a Glass Filling with Water using D3}
\usage{
glass_fill(
  fill_level = 0.65,
  glassWidth = 80,
  glassHeight = 200,
  strokeColor = "#555",
  strokeWidth = 3,
  fillColor = "skyblue",
  renderFillLabel = TRUE,
  labelFontSize = "16px",
  titleText = "Fill level",
  labelColor = "#333",
  titleColor = "#333",
  titleFontSize = "14px",
  font = "Verdana, Geneva, Tahoma, sans-serif"
)
}
\arguments{
\item{fill_level}{Numeric value between 0 and 1 indicating how full the glass should appear.}

\item{glassWidth}{Width of the glass in pixels.}

\item{glassHeight}{Height of the glass in pixels.}

\item{strokeColor}{Color of the glass outline (stroke).}

\item{strokeWidth}{Width of the glass outline stroke.}

\item{fillColor}{Color used to fill the water in the glass.}

\item{renderFillLabel}{Logical indicating whether to display a percentage label above the glass.}

\item{labelFontSize}{Font size of the label, defaults to "16px"}

\item{titleText}{Text to display as the title beneath the glass.}

\item{labelColor}{Color of the label.}

\item{titleColor}{Color of the title text displayed below the glass.}

\item{titleFontSize}{Font size of the title text, defaults to "14px"}

\item{font}{The font name that will be used for the plot text. Defaults to
"Verdana, Geneva, Tahoma, sans-serif"}
}
\value{
An interactive D3 visualization rendered in the RStudio Viewer or web browser.
}
\description{
This function generates an SVG visualization of a glass filled with water to a specified level,
rendered via D3 using the r2d3 package. The fill level, appearance of the glass, and label settings
can be customized.
}
\examples{
glass_fill(fill_level = 0.75)
glass_fill(fill_level = 0.3, fillColor = "lightblue", titleText = "Water Intake")

}
