% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddml_ate.R, R/ddml_att.R, R/ddml_late.R
\name{print.summary.ddml_ate}
\alias{print.summary.ddml_ate}
\alias{print.summary.ddml_att}
\alias{print.summary.ddml_late}
\title{Print Methods for Treatment Effect Estimators.}
\usage{
\method{print}{summary.ddml_ate}(x, digits = 3, ...)

\method{print}{summary.ddml_att}(x, digits = 3, ...)

\method{print}{summary.ddml_late}(x, digits = 3, ...)
}
\arguments{
\item{x}{An object of class \code{summary.ddml_ate},
\code{summary.ddml_att}, and \code{ddml_late}, as returned by
\code{\link[=summary.ddml_ate]{summary.ddml_ate()}}, \code{\link[=summary.ddml_att]{summary.ddml_att()}}, and
\code{\link[=summary.ddml_late]{summary.ddml_late()}}, respectively.}

\item{digits}{The number of significant digits used for printing.}

\item{...}{Currently unused.}
}
\value{
NULL.
}
\description{
Print methods for treatment effect estimators.
}
\examples{
# Construct variables from the included Angrist & Evans (1998) data
y = AE98[, "worked"]
D = AE98[, "morekids"]
X = AE98[, c("age","agefst","black","hisp","othrace","educ")]

# Estimate the average treatment effect using a single base learner, ridge.
ate_fit <- ddml_ate(y, D, X,
                    learners = list(what = mdl_glmnet,
                                    args = list(alpha = 0)),
                    sample_folds = 2,
                    silent = TRUE)
summary(ate_fit)
}
