% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.dcsvm.R
\name{plot.cv.dcsvm}
\alias{plot.cv.dcsvm}
\title{Plot the Cross-Validation Curve of Sparse Density-Convoluted SVM}
\usage{
\method{plot}{cv.dcsvm}(x, sign.lambda, ...)
}
\arguments{
\item{x}{A fitted \code{\link{cv.dcsvm}} object.}

\item{sign.lambda}{Specifies whether to plot against \code{log(lambda)} (default) or its negative if \code{sign.lambda = -1}.}

\item{...}{Other graphical parameters to \code{plot}.}
}
\value{
No return value, only called for plots.
}
\description{
Depicts the cross-validation curves for the sparse density-convoluted SVM.
}
\details{
Plot the Cross-Validation Curve of Sparse Density-Convoluted SVM

Plots the cross-validation curve against a function of \code{lambda} values, including upper and lower standard deviation curves.


This function visualizes the cross-validation curves for a \code{cv.dcsvm} object, which plots the relationship between \code{lambda} values and cross-validation error.
}
\examples{
data(colon)
colon$x <- colon$x[ ,1:100] # Use only the first 100 columns for this example
set.seed(1)
cv <- cv.dcsvm(colon$x, colon$y, lam2=1, nfolds=5)
plot(cv)

}
\seealso{
\code{\link{cv.dcsvm}}.
}
