% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz-methods-create-profiles.R
\name{create_profiles}
\alias{create_profiles}
\title{Generate mastery profiles}
\usage{
create_profiles(x, ...)
}
\arguments{
\item{x}{An object used to generate the possible patterns. This could be a
number (the number of attributes; e.g., \code{3}, \code{4}), or an object that
defines attribute relationships (e.g., a
\link[=structural-model]{structural model} or
\link[=dcm_specify]{model specification}).}

\item{...}{Additional arguments passed to methods. See details.}
}
\value{
A \link[tibble:tibble-package]{tibble} with all possible attribute
patterns. Each row is a profile, and each column indicates whether
the attribute in that column was present (1) or not (0).
}
\description{
Given the number of attributes or model specification, generate all possible
attribute patterns.
}
\details{
Additional arguments passed to methods:

\code{keep_names}: When \code{x} is a \link[=dcm_specify]{model specification}, should
the real attribute names be used (\code{TRUE}; the default), or replaced with
generic names (\code{FALSE}; e.g., \code{"att1"}, \code{"att2"}, \code{"att3"}).

\code{attributes}: When \code{x} is a \link[=structural-model]{structural model}, a vector of
attribute names, as in the \code{qmatrix_meta$attribute_names} of a
\link[=dcm_specify]{DCM specification}.
}
\examples{
create_profiles(3L)

create_profiles(5)

create_profiles(unconstrained(), attributes = c("att1", "att2"))

create_profiles(hdcm("att1 -> att2 -> att3"),
                attributes = c("att1", "att2", "att3"))
}
