% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_dci.R
\name{gather_dci}
\alias{gather_dci}
\title{Calculate thresholded invasive DCI}
\usage{
gather_dci(
  net,
  form,
  from,
  to,
  distance,
  pass,
  nodes,
  seg_weights,
  threshold,
  totweight,
  weighted
)
}
\arguments{
\item{net}{A \code{\link{river_net}} object.}

\item{form}{A string specifying the DCI form to calculate. Options are:
"pot" for potamodromous or "dia" for diadromous.}

\item{pass}{The name of a column in the nodes table of \code{net} containing
numeric passability values. If \code{NULL}, all barriers are assumed to have 0
passability.}

\item{threshold}{Optional numeric value specifying a dispersal limit in map
units. If \code{NULL} (default), no limit is applied.}

\item{totweight}{The total length or weighted length of the whole network.}

\item{weighted}{A logical value indicating whether river lengths in
seg_weights are weighted.}
}
\value{
A data frame which holds raw and relative DCI scores for each segment.
}
\description{
Calculate thresholded invasive DCI
}
\keyword{internal}
