% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DDM.R
\name{DDM}
\alias{DDM}
\title{DDM (Drift Detection Method)}
\description{
Implements the Drift Detection Method (DDM), used for detecting concept drift in data streams
by analyzing the performance of online learners. The method monitors changes in the error rate
of a learner, signaling potential concept drift.
}
\details{
DDM is designed to be simple yet effective for detecting concept drift by monitoring
the error rate of any online classifier. The method is particularly sensitive to
increases in the error rate, which is typically a strong indicator of concept drift.
}
\examples{
set.seed(123)  # Setting a seed for reproducibility
data_part1 <- sample(c(0, 1), size = 100, replace = TRUE, prob = c(0.7, 0.3))

# Introduce a change in data distribution
data_part2 <- sample(c(0, 1), size = 100, replace = TRUE, prob = c(0.3, 0.7))

# Combine the two parts
data_stream <- c(data_part1, data_part2)
ddm <- DDM$new()
# Iterate through the data stream
for (i in seq_along(data_stream)) {
  ddm$add_element(data_stream[i])
  if (ddm$change_detected) {
    message(paste("Drift detected!", i))
  } else if (ddm$warning_detected) {
    # message(paste("Warning detected at position:", i))
  }
}
}
\references{
João Gama, Pedro Medas, Gladys Castillo, Pedro Pereira Rodrigues: Learning
with Drift Detection. SBIA 2004: 286-295

Implementation: https://github.com/scikit-multiflow/scikit-multiflow/blob/a7e316d1cc79988a6df40da35312e00f6c4eabb2/src/skmultiflow/drift_detection/ddm.py
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{min_instances}}{Minimum number of instances required before drift detection begins.}

\item{\code{warning_level}}{Multiplier for the standard deviation to set the warning threshold.}

\item{\code{out_control_level}}{Multiplier for the standard deviation to set the out-of-control threshold.}

\item{\code{sample_count}}{Counter for the number of samples processed.}

\item{\code{miss_prob}}{Current estimated probability of misclassification.}

\item{\code{miss_std}}{Current estimated standard deviation of misclassification probability.}

\item{\code{miss_prob_sd_min}}{Minimum recorded value of misclassification probability plus its standard deviation.}

\item{\code{miss_prob_min}}{Minimum recorded misclassification probability.}

\item{\code{miss_sd_min}}{Minimum recorded standard deviation.}

\item{\code{estimation}}{Current estimation of misclassification probability.}

\item{\code{change_detected}}{Boolean indicating if a drift has been detected.}

\item{\code{warning_detected}}{Boolean indicating if a warning level has been reached.}

\item{\code{delay}}{Delay since the last relevant sample.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DDM-new}{\code{DDM$new()}}
\item \href{#method-DDM-reset}{\code{DDM$reset()}}
\item \href{#method-DDM-add_element}{\code{DDM$add_element()}}
\item \href{#method-DDM-detected_change}{\code{DDM$detected_change()}}
\item \href{#method-DDM-clone}{\code{DDM$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DDM-new"></a>}}
\if{latex}{\out{\hypertarget{method-DDM-new}{}}}
\subsection{Method \code{new()}}{
Initializes the DDM detector with specific parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DDM$new(min_num_instances = 30, warning_level = 2, out_control_level = 3)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{min_num_instances}}{Minimum number of samples required before starting drift detection.}

\item{\code{warning_level}}{Threshold multiplier for setting a warning level.}

\item{\code{out_control_level}}{Threshold multiplier for setting the out-of-control level.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DDM-reset"></a>}}
\if{latex}{\out{\hypertarget{method-DDM-reset}{}}}
\subsection{Method \code{reset()}}{
Resets the internal state of the DDM detector.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DDM$reset()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DDM-add_element"></a>}}
\if{latex}{\out{\hypertarget{method-DDM-add_element}{}}}
\subsection{Method \code{add_element()}}{
Adds a new prediction error value to the model, updates the calculation of the misclassification
probability and its standard deviation, and checks for warnings or drifts based on updated statistics.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DDM$add_element(prediction)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{prediction}}{The new data point (prediction error) to be added to the model.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DDM-detected_change"></a>}}
\if{latex}{\out{\hypertarget{method-DDM-detected_change}{}}}
\subsection{Method \code{detected_change()}}{
Returns a boolean indicating whether a drift has been detected based on the monitored statistics.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DDM$detected_change()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DDM-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DDM-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DDM$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
