% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.report.shannon.r
\name{gl.report.shannon}
\alias{gl.report.shannon}
\title{Report SNP diversity from a genlight object, with reference to Ma, Z., Li, L., & Zhang, Y. P. (2020). Defining individual-level 
genetic diversity and similarity profiles. Scientific reports, 10(1), 5805.}
\usage{
gl.report.shannon(
  x,
  plot.display = TRUE,
  plot.theme = theme_dartR(),
  plot.dir = NULL,
  plot.file = NULL,
  level = "alpha",
  order = 5,
  verbose = 2
)
}
\arguments{
\item{x}{A genlight file (works only for diploid data) [required].}

\item{plot.display}{Specify if plot is to be produced [default TRUE].}

\item{plot.theme}{Theme for the plot. See Details for options
[default theme_dartR()].}

\item{plot.dir}{Directory to save the plot RDS files [default as specified 
by the global working directory or tempdir()]..}

\item{plot.file}{Name for the RDS binary file to save (base name only, 
exclude extension) [default NULL].}

\item{level}{The types of SNP diversity to report. [default 'alpha', also accept 'beta', 'gamma'].}

\item{order}{The number of order to report. Starts from 0. [default 5].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2, unless specified using gl.set.verbosity].}
}
\value{
A dataframe containing SNP diversity per individual
}
\description{
This function needs package adegenet, please install it.
}
\details{
details
\itemize{
\item SNP diversity per individual}
}
\examples{
\dontrun{
obj <- gl.report.shannon(gl)
}
}
\references{
\itemize{
\item Ma, Z., Li, L., & Zhang, Y. P. (2020). Defining individual-level 
genetic diversity and similarity profiles. Scientific reports, 10(1), 5805.}
}
\author{
Ching Ching Lau (Post to
\url{https://groups.google.com/d/forum/dartr})
}
