% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoenc_variational_e.R
\name{autoenc_variational_e}
\alias{autoenc_variational_e}
\title{Variational Autoencoder - Encode}
\usage{
autoenc_variational_e(
  input_size,
  encoding_size,
  batch_size = 32,
  num_epochs = 1000,
  learning_rate = 0.001
)
}
\arguments{
\item{input_size}{input size}

\item{encoding_size}{encoding size}

\item{batch_size}{size for batch learning}

\item{num_epochs}{number of epochs for training}

\item{learning_rate}{learning rate}
}
\value{
A \code{autoenc_variational_e} object.
}
\description{
Creates a deep learning variational autoencoder (VAE) to encode sequences of observations.
Wraps a PyTorch implementation.
}
\examples{
\dontrun{
# Requirements: Python with torch installed and reticulate configured.

# 1) Create sample data
X <- matrix(rnorm(1000), nrow = 50, ncol = 20)

# 2) Fit VAE encoder
ae <- autoenc_variational_e(input_size = 20, encoding_size = 5, num_epochs = 50)
ae <- daltoolbox::fit(ae, X)

# 3) Transform to latent encodings
#    Note: the underlying Python returns [mean | var] concatenated; depending on
#    the implementation, you may receive 2*encoding_size columns.
Z <- daltoolbox::transform(ae, X)
dim(Z)
}

# See:
# https://github.com/cefet-rj-dal/daltoolbox/blob/main/autoencoder/autoenc_variational_e.md
}
\references{
Kingma, D. P., & Welling, M. (2014). Auto-Encoding Variational Bayes.
}
