% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_bayes_estimate.R
\name{d_default_prior_hyper}
\alias{d_default_prior_hyper}
\alias{r_default_prior_hyper}
\title{Default Prior for Group-Level (Hyper) Parameters}
\usage{
d_default_prior_hyper(x, mean, sd, lower, upper, shape, rate, log)

r_default_prior_hyper(n, mean, sd, lower, upper, shape, rate)
}
\arguments{
\item{x}{a numeric vector of length 2 or a matrix with 2 rows and N column.
Here, \code{x[1]} or \code{x[1,]} are interpreted as the group mean(s) and \code{x[2]} or
\code{x[2,]} as the group standard deviation(s).}

\item{mean, sd}{mean and standard deviation of the truncated normal
distribution for the group-level mean. (recycled if necessary)}

\item{lower, upper}{lower and upper bounds for the truncated normal
distribution. (recycled if necessary)}

\item{shape, rate}{shape and rate parameters of the gamma distribution
for the group-level standard deviation. (recycled if necessary)}

\item{log}{logical; if \code{TRUE}, the log-density is returned.}

\item{n}{number of samples to generate.}
}
\value{
For \code{d_default_prior_hyper}, a numeric vector representing the
(log) prior density value(s), with the simplifying assumption of independence
of the mean and standard deviation.

For \code{r_default_prior_hyper}, a 2-row matrix with \code{n} columns. The first
row contains sampled group means; the second row contains sampled
standard deviations. Samples are drawn independently. If \code{n} is 1, then
a named numeric vector is returned.
}
\description{
These functions define and evaluate a default prior distribution for
hyperparameters at the group level.
}
\details{
\code{d_default_prior_hyper} computes the (log) density of a prior for a
two-element vector or a 2xN matrix, containing the mean and standard
deviation (i.e., \code{phi_j}). The mean is modeled with a truncated
normal distribution, and the standard deviation with a gamma distribution.

\code{r_default_prior_hyper} samples hyperparameter values from this prior.

the arguments \code{mean}, \code{sd}, \code{lower}, \code{upper}, \code{shape}, and \code{rate} are
recycled if necessary with respect to the columns of \code{x}. For example,
if \code{x} has two columns, then \code{mean} might provide two values.
}
\keyword{internal}
