% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappedCauchyFunctions.R
\name{wc}
\alias{wc}
\alias{iwc}
\alias{mwc}
\alias{imwc}
\title{Wrapped Cauchy and Integrated Wrapped Cauchy functions}
\usage{
wc(t, mu, rho, tau)

iwc(t, mu, rho, tau)

mwc(t, mus, rhos, gammas, tau)

imwc(t, mus, rhos, gammas, tau)
}
\arguments{
\item{t}{time (numeric, can be vectorized)}

\item{mu}{mean peak}

\item{rho}{concentration parameter (0 <= rho <= 1)}

\item{tau}{period}

\item{mus}{k-vector of mean peaks (assuming k seasons)}

\item{rhos}{k-vector of concentration parameters}

\item{gammas}{k-vector of average hazard values for each component}
}
\value{
numeric value (or vector of values of same length as \code{t}) of the respective function
}
\description{
Fundamental periodic hazard function, mixed hazard function, and their (analytical) integrals.
}
\details{
These functions are mainly internal. \code{wc} and  \code{iwc} are both parameterized in terms of 
peak mean  \eqn{\mu}, concentration parameter  \eqn{\rho}, and period \eqn{\tau} and are "unweighted", i.e. 
\deqn{\int_0^\tau f(t) dt = \tau}

The mixture model versions, \code{mwc} and \code{imwc}, are correspondingly parameterized in terms of 
vectors \code{mus}, \code{rhos}, and also \code{gammas} which correspond to the mean hazard contribution 
of each peak, such that 
\deqn{\int_0^\tau f(t) dt = k\gamma\tau}
}
\examples{

# wrapped Cauchy functions
curve(wc(x, mu = 100, rho = .7, tau = 365), xlim = c(0,365), n = 1e4, 
      ylab = "hazard", xlab = "time")
curve(wc(x, mu = 100, rho = .5, tau = 365), add = TRUE, col = 2)
curve(wc(x, mu = 100, rho = .3, tau = 365), add = TRUE, col = 3)

# mixed wrapped Cauchy functions
curve(mwc(x, mus = c(0.125, 0.5), rhos = c(0.7, 0.5), 
          gammas = c(2, 1), tau = 1), xlim = c(0,1), ylab = "hazard", xlab = "time")
curve(mwc(x, mus = c(0.25, 0.75), rhos = c(0.3, 0.8), 
          gammas = c(0.6, 0.4), tau = 1), add = TRUE, col = 2)
curve(mwc(x, mus = c(0.25, 0.5, 0.75), rhos = c(0.6, 0.5, 0.4), 
          gammas = c(0.5, 0.2, 0.3), tau = 1), add = TRUE, col = 3)
}
