% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.ind.R
\name{param.boot}
\alias{param.boot}
\title{Parameteric Bootstrap Multiple Curve Comparisons for Independent Groups}
\usage{
param.boot(data, group, nboot = 1000, type, Cmat = NULL,
  comparison.names = NULL, option = "p", plot.results = TRUE,
  conf.level = 0.95, xlab = "", adj = 1.5, rounds = 3, start = 0.05,
  end = 0.8, alphas = c(0.01, 0.05, 0.1), fix.seed = FALSE,
  description = "")
}
\arguments{
\item{data}{A matrix specifying data. Each row in the data represents all observations from a specific subject. The number of rows in the data must be the same as the length of the group vector.}

\item{group}{A vector specifying which treatment group each subject belongs to. Must have the same length as the number of rows in data.}

\item{nboot}{An integer specifying the number of bootstraps. The default option is 1000.}

\item{type}{A character string specifying the contrast matrix type corresponding to the ones in \code{contrMat()} in the multcomp package.}

\item{Cmat}{A matrix specifying the contrast matrix. Useful if it is none of the ones in \code{contrMat()}. Either `type' or `Cmat' must be specified. The default option is NULL.}

\item{comparison.names}{A character vector supplying names for the comparisons implied in the contrast matrix.}

\item{option}{A character specifying whether MinP or MaxT should be used for the adjusted p-value calculation. "p" for MinP and "t" for MaxT.}

\item{plot.results}{A boolean specifying whether or not the visuals for the results should be created. The default option is TRUE. All the visuals (simultaneous confidence bands, adjusted p-values, and effect size plots) will be saved in the current directory.}

\item{conf.level}{A numeric that specifies the confidence level of the simultaneous confidence bands. It is one minus the familywise error rate. The default option is 0.95.}

\item{xlab}{A character string specifying the name to be used for the x-axis label of the plots. The default option is the empty character string.}

\item{adj}{A numeric specifying the adjustment factor for the plots. By increasing the number, more white spaces will be created in the plots. The default option is 1.5.}

\item{rounds}{An integer specifying the number of decimal places to be used. The default option is 3.}

\item{start}{A numeric specifying the greyscale to be used for the plot of the simultaneous confidence bands. The value must be greater than zero and less than the value specified for 'end'. The default option is 0.05.}

\item{end}{A numeric specifying the greyscale to be used for the plot of the simultaneous confidence bands. The value must be greater than the value specified for 'start' and less than one. The default option is 0.8.}

\item{alphas}{A numeric vector specifying the FWER cut-off values to be displayed in the plot of the adjusted p-values. The default option is c(0.01,0.05,0.10).}

\item{fix.seed}{A boolean specifying whether or not the seed for the random number generation should be set. This option is useful from the reproducibility point of view. The default option is FALSE.}

\item{description}{A character string specifying the experiment. The default option is the empty character string.}
}
\value{
\item{p.value.all}{A matrix specifying all the adjusted p-values for each comparison at each time point. Each row corresponds to each comparison, and each column corresponds to each time point.}
\item{p.value.comps}{A numeric vector specifying all the adjusted p-values for each comparison. This is the same as the minimum adjusted p-values from each row in \code{p.value.all}.}
\item{p.value.overall}{A numeric specifying the adjusted p-value for the overall conclusion. This is the same as the minimum adjusted p-value in \code{p.value.comps}.}
\item{test.statistic.all}{A matrix specifying all the t-test statistics for each comparison at each time point. Each row corresponds to each comparison, and each column corresponds to each time point.}
\item{test.statistic.comps}{A numeric vector specifying all the test statistics for each comparison. This is the same as the maximum test statistics from each row in \code{test.statistic.all}.}
\item{test.statistic.overall}{A numeric specifying the adjusted p-value for the overall conclusion. This is the same as the maximum test statistic in \code{test.statistic.comps}.}
\item{mean.diff.mat}{A matrix specifying all the mean differences for each comparison at each time point. Each row corresponds to each comparison, and each column corresponds to each time point.}
\item{upper.diff.mat}{A matrix specifying all the upper bounds of the simultaneous confidence intervals for the mean differences for each comparison at each time point. Each row corresponds to each comparison, and each column corresponds to each time point.}
\item{lower.diff.mat}{A matrix specifying all the lower bounds of the simultaneous confidence intervals for the mean differences for each comparison at each time point. Each row corresponds to each comparison, and each column corresponds to each time point.}
\item{es.mat}{A matrix specifying all the effect sizes for each comparison at each time point. \code{es.mat} is the mean difference divided by the pooled standard deviation (Cohen's d). Each row corresponds to each comparison, and each column corresponds to each time point.}
}
\description{
Resampling-based multiple comparisons of adjusted p-values for curve observations with independent groups.
}
\examples{
 #Example with 12 subjects and 3 treatments groups (n1=3, n2=4, n3=5) 
 #having 300 observations per subject.
 #nboot>=1000 is strongly recommended but we use nboot=5 here
 #to cut back on run time.
 nboot<-5
 group<-c(rep(1,3),rep(2,4),rep(3,5))
 group.size<-as.vector(table(group))
 n<-length(group)
 k<-length(group.size)
 m<-360
 range<-c(31:330)
 means<-c(0,0,0)
 sds<-c(0.01,0.015,0.02)

 smoother<-function(data, spar=0.95)
 {
   return(smooth.spline(x=data, spar=spar)$y)
 }

 data<-c()

 set.seed(1)
 for(i in 1:k)
 {
   group.num<-group.size[i]
   mean<-means[i]
   sd<-sds[i]
   datamat<-matrix(rnorm((group.num*m),mean,sd),ncol=m)
   smoothdata<-t(apply(datamat,1,smoother))
   data<-rbind(data,smoothdata[,range])
 }

 #Visualizing the data having three treatment groups
 plot(data[1,]~c(1:300),type='n',main="Simulated Data",
      ylim=c(min(data),max(data)),xlab="Observation",ylab="Data")
 for(j in 1:n)
 {
   lines(data[j,]~c(1:300),col=group[j])
 }

 #Running the test
 #May take a little while to run.
 testresults<-param.boot(data=data,group=group,nboot=nboot,type="Tukey",
 fix.seed=TRUE,description=" (test_ind)")
 testresults


}

