% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1-BasicTerminal.R
\name{getkpl}
\alias{getkpl}
\title{Loop a Keypress}
\usage{
getkpl(escape = "escape", fn = list(), echo = FALSE)
}
\arguments{
\item{escape}{vector of character keypresses that escape the loop. The default is "escape" key.}

\item{fn}{list of named functions}

\item{echo}{whether the keypress should be echoed to the screen if not found in list}
}
\value{
\code{NULL}
}
\description{
Maintain a loop that listens for a keypress, then applies the keypress to a function or echoes it to the terminal screen. The user must be in a terminal to use \code{getkp}; it will not work in RStudio or the R GUI. All actions within R are halted until the keypress is returned.
}
\examples{
f <- list(
	 'up'    = function(){mv(row=-1)},
  'down'  = function(){mv(row=-1)},
	 'left'  = function(){mv(col=-1)},
	 'right' = function(){mv(col=1)}
)
\dontrun{
getkpl(escape = c("escape", "enter"), fn=f, echo=FALSE)
}

}
