% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsvd.R
\name{cuda_ml_tsvd}
\alias{cuda_ml_tsvd}
\title{Truncated SVD.}
\usage{
cuda_ml_tsvd(
  x,
  n_components = 2L,
  eig_algo = c("dq", "jacobi"),
  tol = 1e-07,
  n_iters = 15L,
  transform_input = TRUE,
  cuML_log_level = c("off", "critical", "error", "warn", "info", "debug", "trace")
)
}
\arguments{
\item{x}{The input matrix or dataframe. Each data point should be a row
and should consist of numeric values only.}

\item{n_components}{Desired dimensionality of output data. Must be strictly
less than \code{ncol(x)} (i.e., the number of features in input data).
Default: 2.}

\item{eig_algo}{Eigen decomposition algorithm to be applied to the covariance
matrix. Valid choices are "dq" (divid-and-conquer method for symmetric
matrices) and "jacobi" (the Jacobi method for symmetric matrices).
Default: "dq".}

\item{tol}{Tolerance for singular values computed by the Jacobi method.
Default: 1e-7.}

\item{n_iters}{Maximum number of iterations for the Jacobi method.
Default: 15.}

\item{transform_input}{If TRUE, then compute an approximate representation
of the input data. Default: TRUE.}

\item{cuML_log_level}{Log level within cuML library functions. Must be one of
{"off", "critical", "error", "warn", "info", "debug", "trace"}.
Default: off.}
}
\value{
A TSVD model object with the following attributes:
  - "components": a matrix of \code{n_components} rows to be used for
     dimensionalitiy reduction on new data points.
  - "explained_variance": (only present if "transform_input" is set to TRUE)
    amount of variance within the input data explained by each component.
  - "explained_variance_ratio": (only present if "transform_input" is set to
    TRUE) fraction of variance within the input data explained by each
    component.
   - "singular_values": The singular values corresponding to each component.
    The singular values are equal to the 2-norms of the \code{n_components}
    variables in the lower-dimensional space.
   - "tsvd_params": opaque pointer to TSVD parameters which will be used for
     performing inverse transforms.
}
\description{
Dimensionality reduction using Truncated Singular Value Decomposition.
}
\examples{
library(cuda.ml)

iris.tsvd <- cuda_ml_tsvd(iris[1:4], n_components = 2)
print(iris.tsvd)
}
